#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc AnalysisParam {strname param} {
    upvar $strname str
    global analysis
    global ed

    # find it
    for {set i 0} {$i<$analysis(param,count)} {incr i} {
	if {$analysis(param,$i) == "$param"} {
	    break
	}
    }
    if {$i == $analysis(param,count)} {
	return
    }

    set w ".param"

    set ed(ok) 0

    DialogCreate $w $param -borderwidth 2
    frame $w.param -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.param $w.buttons -fill x -ipadx 4 -ipady 4

    for {set j 0} {$j<$analysis(param,$i,count)} {incr j} {
	set analysis(param,$i,$j,value) $analysis(param,$i,$j,last)
	label $w.param.l$j -text "$analysis(param,$i,$j,title)"
	switch -- $analysis(param,$i,$j,type) {
	    entry {
		entry $w.param.a$j -textvariable analysis(param,$i,$j,value) \
		    -width 40
	    }
	    checkbox {
		checkbutton $w.param.a$j -text {} \
		    -variable analysis(param,$i,$j,value)
	    }
	    menu {
		set l [split $analysis(param,$i,$j,default) |]
		menubutton $w.param.a$j -text "$analysis(param,$i,$j,value)" \
		    -relief raised -menu $w.param.a$j.menu
		set m [menu $w.param.a$j.menu -tearoff 0]
		for {set k 0} {$k<[llength $l]} {incr k} {
			$m add command -label [lindex $l $k] \
			    -command "AnalysisParamMenu analysis(param,$i,$j,value) [lindex $l $k] $w.param.a$j"
		}
	    }
	}
	label $w.param.i$j -text "$analysis(param,$i,$j,info)" \
	    -font {times 12 italic}
	grid $w.param.l$j $w.param.a$j $w.param.i$j -padx 4 -sticky w
    }

    button $w.buttons.ok -text "OK" -default active -command {set ed(ok) 1}
    button $w.buttons.cancel -text "Cancel" -command {set ed(ok) 0}
    pack $w.buttons.ok -side left -padx 10
    pack $w.buttons.cancel -side right -padx 10

    bind $w <Return> {set ed(ok) 1}
    bind $w <Alt-o> "tkButtonInvoke $w.buttons.ok"
    bind $w <Alt-c> "tkButtonInvoke $w.buttons.cancel"

    DialogCenter $w 
    DialogWait $w ed(ok) $w.buttons.ok
    DialogDismiss $w

    if {$ed(ok)} {
	for {set j 0} {$j<$analysis(param,$i,count)} {incr j} {
	    set exp "\\\$$analysis(param,$i,$j,var)"
	    if {[regexp $exp $str]} {
		regsub -all $exp $str "$analysis(param,$i,$j,value)" str
	    }
	    set analysis(param,$i,$j,last) $analysis(param,$i,$j,value)
	}
    }
    set r $ed(ok)
    unset ed
    return $r
}

proc AnalysisParamMenu {varname value menu} {
    upvar $varname var

    set var $value
    $menu configure -text $value
}

proc ParseIRAFParam {filename} {
    global analysis
    global env

    set uparm {}
    if {[info exists env(UPARM)]} {
	set uparm "$env(UPARM)/$filename"
    }
    set iraf {}
    if {[info exists env(HOME)]} {
	set iraf "$env(HOME)/$filename"
    }
    
    if {[file exists "$filename"]} {
	catch {set ch [open "$filename"]}
    } elseif {[file exists "$uparm"]} {
	catch {set ch [open "$uparm"]}
    } elseif {[file exists "$iraf"]} {
	catch {set ch [open "$iraf"]}
    } else {
	return
    }

    set i $analysis(param,count)

    while {[gets $ch line] >= 0} {
	set exp {([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*)}
	if {[regexp $exp $line foo p1 p2 p3 p4 p5 p6 p7]} {
	    if {$p1 != "mode"} {
		regsub -all {\"} $p4 {} p4
		regsub -all {\"} $p7 {} p7
		set j $analysis(param,$i,count)
		set analysis(param,$i,$j,var) "$p1"
		if {$p3 == "h"} {
		    set analysis(param,$i,$j,title) "(${p1})"
		} else {
		    set analysis(param,$i,$j,title) "$p1"
		}
		set analysis(param,$i,$j,info) "$p7"
		incr analysis(param,$i,count)
		switch -- $p2 {
		    b {
			set analysis(param,$i,$j,type) checkbox
			set analysis(param,$i,$j,default) [FromYesNo $p4]
			set analysis(param,$i,$j,last) [FromYesNo $p4]
			set analysis(param,$i,$j,value) [FromYesNo $p4]
		    }
		    s {
			if {$p5 != ""} {
			    set analysis(param,$i,$j,type) menu
			    set analysis(param,$i,$j,default) "$p5"
			} else {
			    set analysis(param,$i,$j,type) entry
			    set analysis(param,$i,$j,default) "$p4"
			}
			set analysis(param,$i,$j,last) "$p4"
			set analysis(param,$i,$j,value) "$p4"
		    }
		    default {
			set analysis(param,$i,$j,type) entry
			set analysis(param,$i,$j,default) "$p4"
			set analysis(param,$i,$j,last) "$p4"
			set analysis(param,$i,$j,value) "$p4"
		    }
		}
	    }
	}
    }

    close $ch
}
