#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CreateInfoPanel {} {
    global ds9
    global menu
    global panner
    global magnifier
    global panel
    global info

    # Panel Frame

    set panel(name) [frame .ds9.panel]

    # Panner
    set panner(name) [canvas $panel(name).pan -width $panner(size) \
		       -height $panner(size) \
		       -bd 2 -relief groove \
		       -highlightthickness 0 -insertofftime 0 -takefocus 0]
    $panner(name) create panner$ds9(visual) -width $panner(size) \
	-height $panner(size) -command panner -tag panner

    # Magnifier
    set magnifier(name) [canvas $panel(name).mag -width $magnifier(size) \
		       -height $magnifier(size) \
		       -bd 2 -relief groove \
		       -highlightthickness 0 -insertofftime 0 -takefocus 0]
    $magnifier(name) create magnifier$ds9(visual) -width $magnifier(size) \
	-height $magnifier(size) -command magnifier -tag magnifier

    # Info
    set info(name) [frame $panel(name).info -relief groove -borderwidth 2]

    label $info(name).fileTitle -text "File"
    label $info(name).fileValue -relief groove -anchor w -width 31 \
	-textvariable info(pFileName)

    label $info(name).objTitle -text "Object"
    label $info(name).objValue -relief groove -anchor w -width 31 \
	-textvariable info(pObject)

    label $info(name).minTitle -text "Min"
    label $info(name).minValue -relief groove -width 13 \
	-textvariable info(pMin)

    label $info(name).maxTitle -text "Max"
    label $info(name).maxValue -relief groove -width 13 \
	-textvariable info(pMax)

    label $info(name).lowTitle -text "Low"
    label $info(name).lowValue -relief groove -width 13 \
	-textvariable info(pLow)

    label $info(name).highTitle -text "High"
    label $info(name).highValue -relief groove -width 13 \
	-textvariable info(pHigh)

    label $info(name).valueTitle -text "Value" -width 9 -anchor w
    frame $info(name).valueValue
    label $info(name).valueValue.v -relief groove -width 13 \
	-textvariable info(pValue)

    label $info(name).valueValue.red -relief groove -width 10 \
	-textvariable info(pValue,red)
    label $info(name).valueValue.green -relief groove -width 10 \
	-textvariable info(pValue,green)
    label $info(name).valueValue.blue -relief groove -width 9 \
	-textvariable info(pValue,blue)

    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	set info(pWCSCoord,$l) "WCS $l"
	label $info(name).wcsLabel$l -anchor w -width 8 -textvariable \
	    info(pWCSCoord,$l)

	set info(pWCSXName,$l) [label $info(name).wcsXLabel$l -text "" \
				    -font {symbol 12} -width 3]
	label $info(name).wcsXValue$l -relief groove -width 13 \
	    -textvariable info(pWCSX,$l)
	set info(pWCSYName,$l) [label $info(name).wcsYLabel$l -text "" \
				    -font {symbol 12} -width 3]
	label $info(name).wcsYValue$l -relief groove -width 13 \
	    -textvariable info(pWCSY,$l)
    }

    label $info(name).detectorTitle -text "Detector"
    label $info(name).detectorXLabel -text "X"
    label $info(name).detectorXValue -relief groove -width 13 \
	-textvariable info(pDetectorX)
    label $info(name).detectorYLabel -text "Y"
    label $info(name).detectorYValue -relief groove -width 13 \
	-textvariable info(pDetectorY)

    label $info(name).amplifierTitle -text "Amp"
    label $info(name).amplifierXLabel -text "X"
    label $info(name).amplifierXValue -relief groove -width 13 \
	-textvariable info(pAmplifierX)
    label $info(name).amplifierYLabel -text "Y"
    label $info(name).amplifierYValue -relief groove -width 13 \
	-textvariable info(pAmplifierY)

    label $info(name).physicalTitle -text "Physical"
    label $info(name).physicalXLabel -text "X"
    label $info(name).physicalXValue -relief groove -width 13 \
	-textvariable info(pPhysicalX)
    label $info(name).physicalYLabel -text "Y"
    label $info(name).physicalYValue -relief groove -width 13 \
	-textvariable info(pPhysicalY)

    label $info(name).imageTitle -text "Image"
    label $info(name).imageXLabel -text "X"
    label $info(name).imageXValue -relief groove -width 13 \
	-textvariable info(pImageX)
    label $info(name).imageYLabel -text "Y"
    label $info(name).imageYValue -relief groove -width 13 \
	-textvariable info(pImageY)

    label $info(name).frame -textvariable info(pFrame) -width 8 -anchor w

    label $info(name).zoomtitle -text "Zoom"
    label $info(name).zoomValue -relief groove -width 13 \
	-textvariable info(pZoom)

    label $info(name).angleTitle -text "Ang"
    label $info(name).angleValue -relief groove -width 13 \
	-textvariable info(pAngle)
}

proc UpdateInfoPanel {} {
    global info

    global debug
    if {$debug(tcl,info)} {
	puts "UpdateInfoPanel"
    }

    set row 0
    if {$info(filename)} {
	grid rowconfigure $info(name) $row -pad 2
	grid $info(name).fileTitle -row $row -column 0 -sticky w
	grid $info(name).fileValue -row $row -column 2 -padx 2 \
	    -sticky w -columnspan 3
	incr row
    } else {
	grid forget $info(name).fileTitle
	grid forget $info(name).fileValue
    }

    if {$info(object)} {
	grid rowconfigure $info(name) $row -pad 2
	grid $info(name).objTitle -row $row -column 0 -sticky w
	grid $info(name).objValue -row $row -column 2 -padx 2 \
	    -sticky w -columnspan 3
	incr row
    } else {
	grid forget $info(name).objTitle
	grid forget $info(name).objValue
    }

    if {$info(minmax)} {
	grid rowconfigure $info(name) $row -pad 2
	grid $info(name).minTitle -row $row -column 0 -sticky w
	grid $info(name).minValue -row $row -column 2 -padx 2 -sticky w
	grid $info(name).maxTitle -row $row -column 3 -sticky w
	grid $info(name).maxValue -row $row -column 4 -padx 2 -sticky w

	grid $info(name).lowTitle -row $row -column 0 -sticky w
	grid $info(name).lowValue -row $row -column 2 -padx 2 -sticky w
	grid $info(name).highTitle -row $row -column 3 -sticky w
	grid $info(name).highValue -row $row -column 4 -padx 2 -sticky w
	incr row
    } else {
	grid forget $info(name).minTitle
	grid forget $info(name).minValue
	grid forget $info(name).maxTitle
	grid forget $info(name).maxValue
	grid forget $info(name).lowTitle
	grid forget $info(name).lowValue
	grid forget $info(name).highTitle
	grid forget $info(name).highValue
    }

    grid rowconfigure $info(name) $row -pad 2
    grid $info(name).valueTitle -row $row -column 0 -sticky w
    grid $info(name).valueValue -row $row -column 2 -padx 2 \
	-sticky w -columnspan 3

    grid $info(name).valueValue.v
    grid forget $info(name).valueValue.red
    grid forget $info(name).valueValue.green
    grid forget $info(name).valueValue.blue
    incr row

    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	if {$info(wcs$l)} {
	    grid rowconfigure $info(name) $row -pad 1
	    grid $info(name).wcsLabel$l  -row $row -column 0 -sticky w
	    grid $info(name).wcsXLabel$l -row $row -column 1 -sticky e
	    grid $info(name).wcsXValue$l -row $row -column 2 -padx 2
	    grid $info(name).wcsYLabel$l -row $row -column 3 -sticky e

	    grid $info(name).wcsYValue$l -row $row -column 4 -padx 2
	    incr row
	} else {
	    grid forget $info(name).wcsLabel$l
	    grid forget $info(name).wcsXLabel$l
	    grid forget $info(name).wcsXValue$l
	    grid forget $info(name).wcsYLabel$l
	    grid forget $info(name).wcsYValue$l
	}
    }

    if {$info(detector)} {
	grid rowconfigure $info(name) $row -pad 2
	grid $info(name).detectorTitle -row $row -column 0 -sticky w
	grid $info(name).detectorXLabel -row $row -column 1 -sticky e
	grid $info(name).detectorXValue -row $row -column 2 -padx 2
	grid $info(name).detectorYLabel -row $row -column 3 -sticky e
	grid $info(name).detectorYValue -row $row -column 4 -padx 2
	incr row
    } else {
	grid forget $info(name).detectorTitle
	grid forget $info(name).detectorXLabel
	grid forget $info(name).detectorXValue
	grid forget $info(name).detectorYLabel
	grid forget $info(name).detectorYValue
    }

    if {$info(amplifier)} {
	grid rowconfigure $info(name) $row -pad 2
	grid $info(name).amplifierTitle -row $row -column 0 -sticky w
	grid $info(name).amplifierXLabel -row $row -column 1 -sticky e
	grid $info(name).amplifierXValue -row $row -column 2 -padx 2
	grid $info(name).amplifierYLabel -row $row -column 3 -sticky e
	grid $info(name).amplifierYValue -row $row -column 4 -padx 2
	incr row
    } else {
	grid forget $info(name).amplifierTitle
	grid forget $info(name).amplifierXLabel
	grid forget $info(name).amplifierXValue
	grid forget $info(name).amplifierYLabel
	grid forget $info(name).amplifierYValue
    }

    if {$info(physical)} {
	grid rowconfigure $info(name) $row -pad 2
	grid $info(name).physicalTitle -row $row -column 0 -sticky w
	grid $info(name).physicalXLabel -row $row -column 1 -sticky e
	grid $info(name).physicalXValue -row $row -column 2 -padx 2
	grid $info(name).physicalYLabel -row $row -column 3 -sticky e
	grid $info(name).physicalYValue -row $row -column 4 -padx 2
	incr row
    } else {
	grid forget $info(name).physicalTitle
	grid forget $info(name).physicalXLabel
	grid forget $info(name).physicalXValue
	grid forget $info(name).physicalYLabel
	grid forget $info(name).physicalYValue
    }

    if {$info(image)} {
	grid rowconfigure $info(name) $row -pad 2
	grid $info(name).imageTitle -row $row -column 0 -sticky w
	grid $info(name).imageXLabel -row $row -column 1 -sticky e
	grid $info(name).imageXValue -row $row -column 2 -padx 2
	grid $info(name).imageYLabel -row $row -column 3 -sticky e
	grid $info(name).imageYValue -row $row -column 4 -padx 2
	incr row
    } else {
	grid forget $info(name).imageTitle
	grid forget $info(name).imageXLabel
	grid forget $info(name).imageXValue
	grid forget $info(name).imageYLabel
	grid forget $info(name).imageYValue
    }

    if {$info(frame)} {
	grid rowconfigure $info(name) $row -pad 2
	grid $info(name).frame -row $row -column 0 -sticky w
	grid $info(name).zoomtitle -row $row -column 1 -sticky w
	grid $info(name).zoomValue -row $row -column 2 -padx 2 -sticky w
	grid $info(name).angleTitle -row $row -column 3
	grid $info(name).angleValue -row $row -column 4 -padx 2 -sticky w
	incr row
    } else {
	grid forget $info(name).frame
	grid forget $info(name).zoomtitle
	grid forget $info(name).zoomValue
	grid forget $info(name).angleTitle
	grid forget $info(name).angleValue
    }
}

proc EnterInfoBox {which x y sys} {
    global info

    switch -- [$which get type] {
	base {
	    grid forget $info(name).valueValue.red
	    grid forget $info(name).valueValue.green
	    grid forget $info(name).valueValue.blue
	    grid $info(name).valueValue.v
	}
	rgb {
	    grid forget $info(name).valueValue.v
	    grid $info(name).valueValue.red $info(name).valueValue.green \
		$info(name).valueValue.blue
	}
    }

    UpdateInfoBox $which $x $y $sys

    set info(pFrame) $which
    set info(pZoom) [$which get zoom fixed]
    set info(pAngle) [$which get rotate fixed]
}

proc LeaveInfoBox {} {
    global ds9
    global current

    global debug
    if {$debug(tcl,info)} {
	puts "LeaveInfoBox"
    }

    ClearInfoBoxCoords
}

proc MotionInfoBox {which x y sys} {
    UpdateInfoBox $which $x $y $sys
}

proc ClearInfoBox {} {
    global info

    global debug
    if {$debug(tcl,info)} {
	puts "ClearInfoBox"
    }

    set info(pFileName) ""
    set info(pObject) ""

    set info(pMin) ""
    set info(pMax) ""
    set info(pLow) ""
    set info(pHigh) ""

    ClearInfoBoxCoords

    set info(pFrame) Frame
    set info(pZoom) ""
    set info(pAngle) ""
}

proc RefreshInfoBox {which} {
    global info

    global debug
    if {$debug(tcl,info)} {
	puts "RefreshInfoBox"
    }

    switch -- [$which get type] {
	base {
	    grid forget $info(name).valueValue.red
	    grid forget $info(name).valueValue.green
	    grid forget $info(name).valueValue.blue
	    grid $info(name).valueValue.v
	}
	rgb {
	    grid forget $info(name).valueValue.v
	    grid $info(name).valueValue.red $info(name).valueValue.green \
		$info(name).valueValue.blue
	}
    }

    $which get info result
    SetInfoBoxFileName result

    # not needed if panner will generate an EnterWindow Event
    ClearInfoBoxCoords

    set info(pFrame) $which
    set info(pZoom) [$which get zoom fixed]
    set info(pAngle) [$which get rotate fixed]
}

proc UpdateInfoBox {which x y sys} {
# Note: we want to avoid changing the displayed data at all cost. 
# Updating a label widget is very costly. Therefor, try to test 
# for change of data before updating.

    global debug
    if {$debug(tcl,info)} {
	puts "UpdateInfoBox"
    }

    global wcs
    $which get info $sys $x $y $wcs(sky) $wcs(skyformat) result
    SetInfoBoxFileName result

    global info
    set info(pValue) $result(value)
    set info(pValue,red) $result(value,red)
    set info(pValue,green) $result(value,green)
    set info(pValue,blue) $result(value,blue)

    if {$info(image)} {
	set info(pImageX) $result(xImage)
	set info(pImageY) $result(yImage)
    }

    if {$info(physical)} {
	set info(pPhysicalX) $result(xPhysical)
	set info(pPhysicalY) $result(yPhysical)
    }

    if {$info(amplifier)} {
	set info(pAmplifierX) $result(xAmplifier)
	set info(pAmplifierY) $result(yAmplifier)
    }

    if {$info(detector)} {
	set info(pDetectorX) $result(xDetector)
	set info(pDetectorY) $result(yDetector)
    }

    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	if {$info(wcs$l)} {
	    set info(pWCSX,$l) $result(xWCS,$l)
	    set info(pWCSY,$l) $result(yWCS,$l)

	    switch -- $result(sysWCS,$l) {
		fk4 {
		    if {$info(pWCSCoord,$l) != "FK4"} {
			set info(pWCSCoord,$l) "FK4"
			$info(pWCSXName,$l) configure -text "a" \
			    -font {symbol 12}
			$info(pWCSYName,$l) configure -text "d" \
			    -font {symbol 12}
		    }
		}
		fk5 {
		    if {$info(pWCSCoord,$l) != "FK5"} {
			set info(pWCSCoord,$l) "FK5"
			$info(pWCSXName,$l) configure -text "a" \
			    -font {symbol 12}
			$info(pWCSYName,$l) configure -text "d" \
			    -font {symbol 12}
		    }
		}
		icrs {
		    if {$info(pWCSCoord,$l) != "ICRS"} {
			set info(pWCSCoord,$l) "ICRS"
			$info(pWCSXName,$l) configure -text "a" \
			    -font {symbol 12}
			$info(pWCSYName,$l) configure -text "d" \
			    -font {symbol 12}
		    }
		}
		galactic {
		    if {$info(pWCSCoord,$l) != "Galactic"} {
			set info(pWCSCoord,$l) "Galactic"
			$info(pWCSXName,$l) configure -text "l" -font \
			    {-family times -slant italic}
			$info(pWCSYName,$l) configure -text "b" -font \
			    {-family times -slant italic}
		    }
		}
		ecliptic {
		    if {$info(pWCSCoord,$l) != "Ecliptic"} {
			set info(pWCSCoord,$l) "Ecliptic"
			$info(pWCSXName,$l) configure -text "l" \
			    -font {symbol 12}
			$info(pWCSYName,$l) configure -text "b" \
			    -font {symbol 12}
		    }
		}
		{} {
		    if {$info(pWCSCoord,$l) != "WCS $l"} {
			set info(pWCSCoord,$l) "WCS $l"
			$info(pWCSXName,$l) configure -text ""
			$info(pWCSYName,$l) configure -text ""
		    }
		}
		default {
		    if {$info(pWCSCoord,$l) != $result(sysWCS,$l)} {
			set info(pWCSCoord,$l) $result(sysWCS,$l)
 			set unit1 [string range $result(xUnitWCS,$l) 0 2]
 			set unit2 [string range $result(yUnitWCS,$l) 0 2]
			$info(pWCSXName,$l) configure -text "$unit1" \
			    -font {times 12}
			$info(pWCSYName,$l) configure -text "$unit2" \
			    -font {times 12}
		    }
		}
	    }
	}
    }
}

proc SetInfoBoxFileName {rvar} {
    upvar $rvar result
    global info

    if {$info(pFileName) != $result(filename)} {
	set info(pFileName) $result(filename)
    }
    if {$info(pObject) != $result(objectname)} {
	set info(pObject) $result(objectname)
    }

    if {$info(pMin) != $result(min)} {
	set info(pMin) $result(min)
    }
    if {$info(pMax) != $result(max)} {
	set info(pMax) $result(max)
    }
    if {$info(pLow) != $result(low)} {
	set info(pLow) $result(low)
    }
    if {$info(pHigh) != $result(high)} {
	set info(pHigh) $result(high)
    }
}

proc ClearInfoBoxCoords {} {
    global info

    set info(pValue) ""
    set info(pValue,red) ""
    set info(pValue,green) ""
    set info(pValue,blue) ""

    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	set info(pWCSCoord,$l) "WCS $l"
	$info(pWCSXName,$l) configure -text ""
	set info(pWCSX,$l) ""
	$info(pWCSYName,$l) configure -text ""
	set info(pWCSY,$l) ""
    }

    set info(pDetectorX) ""
    set info(pDetectorY) ""
    set info(pAmplifierX) ""
    set info(pAmplifierY) ""
    set info(pPhysicalX) ""
    set info(pPhysicalY) ""
    set info(pImageX) ""
    set info(pImageY) ""
}

proc DisplayCoordDialog {which x y sys} {
    global coord

    set r {}

    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	if {"$coord(wcs$l)" && [$which has wcs "wcs$l"]} {
	    set cd \
    "[$which get coordinates $sys $x $y wcs$l $coord(sky) $coord(skyformat)]"

	    if [$which has wcs equatorial "wcs$l"] {
		append r " [lindex $cd 0] [lindex $cd 1] $coord(sky)"
	    } else {
		set name [$which get wcs name "wcs$l"]
		if {$name != {}} {
		    append r " [lindex $cd 0] [lindex $cd 1] $name"
		} else {
		    append r " [lindex $cd 0] [lindex $cd 1] [lindex $cd 3]"
		}
	    }
	}
    }

    if {$coord(detector) && [$which has detector]} {
	append r " [$which get coordinates $sys $x $y detector] detector"
    }

    if {$coord(amplifier) && [$which has amplifier]} {
	append r " [$which get coordinates $sys $x $y amplifier] amplifier"
    }

    if {$coord(physical) && [$which has physical]} {
	append r " [$which get coordinates $sys $x $y physical] physical"
    }

    if {$coord(image)} {
	append r " [$which get coordinates $sys $x $y image]"
    }

    if {$coord(value)} {
	append r " [$which get value $sys $x $y]"
    }

    append r " \n"

    SimpleTextDialog coord Coordinates 80 20 append bottom "$r"
}

proc ProcessViewCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global info
    global panner
    global magnifier
    global buttons
    global colorbar
    global graphHorz
    global graphVert
    global rgb

    set yesno [lindex $var [expr $i+1]]

    switch -- [string tolower [lindex $var $i]] {
	info {set info(view) [FromYesNo $yesno]}
	panner {set panner(view) [FromYesNo $yesno]}
	magnifier {set magnifier(view) [FromYesNo $yesno]}
	buttons {set buttons(view) [FromYesNo $yesno]}
	colorbar {set colorbar(view) [FromYesNo $yesno]}
	horzgraph {set graphHorz(view) [FromYesNo $yesno]}
	vertgraph {set graphVert(view) [FromYesNo $yesno]}

	filename {set info(filename) [FromYesNo $yesno]}
	object {set info(object) [FromYesNo $yesno]}
	minmax {set info(minmax) [FromYesNo $yesno]}
	frame {set info(frame) [FromYesNo $yesno]}

	detector {set info(detector) [FromYesNo $yesno]}
	amplifier {set info(amplifier) [FromYesNo $yesno]}
	physical {set info(physical) [FromYesNo $yesno]}
	image {set info(image) [FromYesNo $yesno]}
	wcs {set info(wcs) [FromYesNo $yesno]}
	wcsa {set info(wcsA) [FromYesNo $yesno]}
	wcsb {set info(wcsB) [FromYesNo $yesno]}
	wcsc {set info(wcsC) [FromYesNo $yesno]}
	wcsd {set info(wcsD) [FromYesNo $yesno]}
	wcse {set info(wcsE) [FromYesNo $yesno]}
	wcsf {set info(wcsF) [FromYesNo $yesno]}
	wcsg {set info(wcsG) [FromYesNo $yesno]}
	wcsh {set info(wcsH) [FromYesNo $yesno]}
	wcsi {set info(wcsI) [FromYesNo $yesno]}
	wcsj {set info(wcsJ) [FromYesNo $yesno]}
	wcsk {set info(wcsK) [FromYesNo $yesno]}
	wcsl {set info(wcsL) [FromYesNo $yesno]}
	wcsm {set info(wcsM) [FromYesNo $yesno]}
	wcsn {set info(wcsN) [FromYesNo $yesno]}
	wcso {set info(wcsO) [FromYesNo $yesno]}
	wcsp {set info(wcsP) [FromYesNo $yesno]}
	wcsq {set info(wcsQ) [FromYesNo $yesno]}
	wcsr {set info(wcsR) [FromYesNo $yesno]}
	wcss {set info(wcsS) [FromYesNo $yesno]}
	wcst {set info(wcsT) [FromYesNo $yesno]}
	wcsu {set info(wcsU) [FromYesNo $yesno]}
	wcsv {set info(wcsV) [FromYesNo $yesno]}
	wcsw {set info(wcsW) [FromYesNo $yesno]}
	wcsx {set info(wcsX) [FromYesNo $yesno]}
	wcsy {set info(wcsY) [FromYesNo $yesno]}
	wcsz {set info(wcsZ) [FromYesNo $yesno]}

	red {set rgb(red) [FromYesNo $yesno]; RGBView}
	green {set rgb(green) [FromYesNo $yesno]; RGBView}
	blue {set rgb(blue) [FromYesNo $yesno]; RGBView}
    }
    incr i

    UpdateView
    UpdateInfoPanel
}
