/*
*+
*  Name:
*     fwinmap.c

*  Purpose:
*     Define a FORTRAN 77 interface to the AST WinMap class.

*  Type of Module:
*     C source file.

*  Description:
*     This file defines FORTRAN 77-callable C functions which provide
*     a public FORTRAN 77 interface to the WinMap class.

*  Routines Defined:
*     AST_ISAWINMAP
*     AST_WINMAP

*  Copyright:
*     Copyright (C) 2004 Central Laboratory of the Research Councils

*  Authors:
*     DSB: D.S. Berry (Starlink)

*  History:
*     23-OCT-1996 (DSB):
*        Original version.
*/

/* Define the astFORTRAN77 macro which prevents error messages from
   AST C functions from reporting the file and line number where the
   error occurred (since these would refer to this file, they would
   not be useful). */
#define astFORTRAN77

/* Header files. */
/* ============= */
#include "f77.h"                 /* FORTRAN <-> C interface macros (SUN/209) */
#include "c2f77.h"               /* F77 <-> C support functions/macros */
#include "error.h"               /* Error reporting facilities */
#include "memory.h"              /* Memory handling facilities */
#include "winmap.h"              /* C interface to the WinMap class */

F77_LOGICAL_FUNCTION(ast_isawinmap)( INTEGER(THIS),
                                     INTEGER(STATUS) ) {
   GENPTR_INTEGER(THIS)
   F77_LOGICAL_TYPE(RESULT);

   astAt( "AST_ISAWINMAP", NULL, 0 );
   astWatchSTATUS(
      RESULT = astIsAWinMap( astI2P( *THIS ) ) ? F77_TRUE : F77_FALSE;
   )
   return RESULT;
}

F77_INTEGER_FUNCTION(ast_winmap)( INTEGER(NAXES),
                                  DOUBLE(C1_IN),
                                  DOUBLE(C2_IN),
                                  DOUBLE(C1_OUT),
                                  DOUBLE(C2_OUT), 
                                  CHARACTER(OPTIONS),
                                  INTEGER(STATUS)
                                  TRAIL(OPTIONS) ) {
   GENPTR_INTEGER(NAXES)
   GENPTR_DOUBLE(C1_IN)
   GENPTR_DOUBLE(C2_IN)
   GENPTR_DOUBLE(C1_OUT)
   GENPTR_DOUBLE(C2_OUT)
   GENPTR_CHARACTER(OPTIONS)
   F77_INTEGER_TYPE(RESULT);
   char *options;
   int i;

   astAt( "AST_WINMAP", NULL, 0 );
   astWatchSTATUS(
      options = astString( OPTIONS, OPTIONS_length );

/* Change ',' to '\n' (see AST_SET in fobject.c for why). */
      if ( astOK ) {
         for ( i = 0; options[ i ]; i++ ) {
            if ( options[ i ] == ',' ) options[ i ] = '\n';
         }
      }
      RESULT = astP2I( astWinMap( *NAXES, C1_IN, C2_IN, C1_OUT, C2_OUT, 
                                  "%s", options ) );
      astFree( options );
   )
   return RESULT;
}
