// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <stdlib.h>

#include "itt.h"
#include "util.h"

static int sequenceID = 1;

// ITT

ITT::ITT()
{
  id = sequenceID++;
  name = NULL;
  fileName = NULL;
  next = NULL;
  size = 0;
  values = NULL;
}

ITT::~ITT()
{
  if (name)
    delete name;

  if (fileName)
    delete fileName;

  if (values)
    delete [] values;
}

float ITT::operator[](int i)
{
  if (i >= 0 && i < size)
    return values[i];
  else
    return 0;
}

void ITT::setName(const char* n)
{
  if (name)
    delete name;

  name = dupstr(n);
}

void ITT::setFileName(const char* n)
{
  if (fileName)
    delete fileName;

  fileName = dupstr(n);
}

int ITT::load()
{
  // Determine if we can read the file

  ifstream f(fileName);
  if (!f)
    return 0;
  
  // Figure out the number of colors

  float junk;
  while (1) {
    f >> junk;
    if (f.eof())
      break;
    size++;
  }
  f.close();

  // allocate space for our colors

  values = new float[size];

  // and read the colors

  f.open(fileName);
  for (int i=0; i<size; i++)
    f >> values[i];
  f.close();

  return 1;
}

ostream& operator<<(ostream& s, ITT& c)
{
  s << "type: ITT" << endl;

  if (c.name)
    s << "name: " << c.name << endl;

  if (c.fileName)
    s << "file name: " << c.fileName << endl;

  s << "size: " << c.size << endl;

  if (c.next)
    s << "next: " << c.next->getName() << endl;

  s << "values: " << endl;
  if (c.values)
    for (int i=0; i<c.size; i++)
      s << c.values[i] << endl;

  return s;
}
