/*
 *	Copyright (c) 1999-2003 Smithsonian Astrophysical Observatory
 */

/*
 *
 * launch.h -- declarations for launching a program
 *
 */

#ifndef	__launch_h
#define	__launch_h

#if HAVE_CONFIG_H
#include <conf.h>
#endif

#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <fcntl.h>                                                       
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/socket.h>                                                  
#if HAVE_STRING_H
#include <string.h>
#endif
#if HAVE_MALLOC_H
#include <malloc.h>
#endif
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#if HAVE_CYGWIN
#include <process.h>
#endif
#include <word.h>
#include <prsetup.h>

#ifndef NewString
#define NewString(str) \
	((str) != (char *)NULL ? \
	((char *)strcpy((char *)malloc((unsigned)strlen(str)+1), str)) : \
	(char *)NULL)
#endif

#ifndef SZ_LINE
#define SZ_LINE 4096
#endif

#ifndef MIN
#define MIN(a,b) (((a)<(b))?(a):(b))
#endif

#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif

#ifndef ABS
#define ABS(x)		((x)<0?(-x):(x))
#endif

_PRbeg

int launch _PRx((char *cmdstring, int wait, char **stdfiles));
pid_t launchpid _PRx((void));

_PRend

#endif
