// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __basemarker_h__
#define __basemarker_h__

#include "marker.h"

#define MAXANNULI 512
#define MAXANGLES 720

class BaseMarker : public Marker {
protected:
  int segments;
  int annuli;
  Vector** vertices;

protected:
  virtual void updateHandles() {}
  virtual void calcPoints(double) {}

private:
  void render(Drawable drawable, const Matrix& matrix, double, RenderMode);
  void newVertices();
  void deleteVertices();

public:
  BaseMarker(const BaseMarker&);
  BaseMarker(FrameBase*, const Vector&, int, const char*, int, const char*, 
	     const char*, unsigned short, const char*,
	     const List<Tag>&);

  virtual Marker* dup() =0;
  virtual void updateBBox();

  virtual void ps(int);
  int getAnnuliCount() {return annuli;}

  virtual void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char) =0;
  virtual void listCiao(ostream&, CoordSystem, SkyFrame, SkyFormat, char) =0;
  virtual void listSAOimage(ostream&,CoordSystem,SkyFrame,SkyFormat,char) =0;
  virtual void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, char) =0;
};

#endif
