// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colorscaletrue16_h__
#define __colorscaletrue16_h__

#include "colorscale.h"

class ColorScaleTrueColor16 : public virtual ColorScale {
public:
  ColorScaleTrueColor16(int, Visual*, int);
  virtual ~ColorScaleTrueColor16();
};

class LinearScaleTrueColor16 :
public virtual ColorScale, 
public LinearScale, 
public ColorScaleTrueColor16 {
public:
  LinearScaleTrueColor16(int, unsigned short*, unsigned char*, int, 
			 Visual*, int);
};

class LogScaleTrueColor16 :
public virtual ColorScale, 
public LogScale, 
public ColorScaleTrueColor16 {
public:
  LogScaleTrueColor16(int, unsigned short*, unsigned char*, int, 
		      Visual*, int);
};

class SquaredScaleTrueColor16 :
public virtual ColorScale, 
public SquaredScale, 
public ColorScaleTrueColor16 {
public:
  SquaredScaleTrueColor16(int, unsigned short*, unsigned char*, int, 
			  Visual*, int);
};

class SqrtScaleTrueColor16 :
public virtual ColorScale, 
public SqrtScale, 
public ColorScaleTrueColor16 {
public:
  SqrtScaleTrueColor16(int, unsigned short*, unsigned char*, int, 
		       Visual*, int);
};

class IISScaleTrueColor16 :
public virtual ColorScale, 
public IISScale, 
public ColorScaleTrueColor16 {
public:
  IISScaleTrueColor16(unsigned short*, unsigned char*, int, 
		      Visual*, int);
};

class HistEquScaleTrueColor16 :
public virtual ColorScale, 
public HistEquScale, 
public ColorScaleTrueColor16 {
public:
  HistEquScaleTrueColor16(int, unsigned short*, unsigned char*, int, 
			  double*, int, Visual*, int);
};

#endif
