
#ifndef IIRBASE_ARRAY_TYPE_DEFINITION_HH
#define IIRBASE_ARRAY_TYPE_DEFINITION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIR_TypeDefinition.hh"

class IIR_ArrayTypeDefinition;
class IIR_ScalarTypeDefinition;

class IIRBase_ArrayTypeDefinition : public IIR_TypeDefinition {

public:
  IIR_Kind get_kind() const {return IIR_ARRAY_TYPE_DEFINITION;}
  IIR_Char *get_kind_text() const {return "IIR_ArrayTypeDefinition";}

  void set_index_subtype( IIR_ScalarTypeDefinition *index_subtype );
  IIR_ScalarTypeDefinition *get_index_subtype();

  void set_element_subtype( IIR_TypeDefinition *element_subtype );
  IIR_TypeDefinition *get_element_subtype();

  // This method returns TRUE if the element_subtype is REALLY that of the
  // element, or FALSE if it's simply a placeholder for a mutlidimensional array.
  IIR_Boolean is_element();
  void set_is_element( IIR_Boolean );

protected:
  IIRBase_ArrayTypeDefinition();
  virtual ~IIRBase_ArrayTypeDefinition() = 0;
    
private:
  IIR_ScalarTypeDefinition *my_index_subtype;
  IIR_TypeDefinition *my_element_subtype;
  IIR_Boolean my_is_element;
};
#endif
