
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_DyadicOperator.hh"
#include "savant.hh"

IIRBase_DyadicOperator::IIRBase_DyadicOperator(){
  set_implementation( NULL );
  set_left_operand( NULL );
  set_right_operand( NULL );
}

IIRBase_DyadicOperator::~IIRBase_DyadicOperator(){
}

void 
IIRBase_DyadicOperator::set_implementation( IIR_SubprogramDeclaration *implementation ){
  this->implementation = implementation;
}


IIR_SubprogramDeclaration *
IIRBase_DyadicOperator::get_implementation(){
  return implementation;
}

void 
IIRBase_DyadicOperator::set_left_operand( IIR *left_operand ){
  this->left_operand = left_operand;
}

IIR *
IIRBase_DyadicOperator::get_left_operand(){
  return left_operand;
}

void 
IIRBase_DyadicOperator::set_right_operand( IIR *right_operand ){
  this->right_operand = right_operand;
}

IIR *
IIRBase_DyadicOperator::get_right_operand(){
  return right_operand;
}
