// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIRScram_Allocator.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_AccessTypeDefinition.hh"
#include "symbol_table.hh"
#include "set.hh"
#include "published_file.hh"

IIRScram_Allocator::~IIRScram_Allocator() {}


void 
IIRScram_Allocator::_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << "new ";
  get_type_mark()->_publish_vhdl(_vhdl_out);
  
  if( get_value() != NULL ){
    ASSERT( get_value()->_is_resolved() == TRUE );

    _vhdl_out << "'( ";
    get_value()->_publish_vhdl( _vhdl_out );
    _vhdl_out << " )";    
  }
}

ostream &
IIRScram_Allocator::_print( ostream &os ){
  os << "new ";
  os << *get_type_mark();

  return os;
}

set<IIR_TypeDefinition> *
IIRScram_Allocator::_get_rval_set( IIR_Boolean (IIR::*)() ){
  set<IIR_TypeDefinition> *retval = new set<IIR_TypeDefinition>();
  
  set<IIR_AccessTypeDefinition> *access_types;
  access_types = _get_symbol_table()->get_in_scope_access_types();
  
  IIR_TypeDefinition *current = access_types->get_element();
  while( current != NULL ){
    retval->add( current );
    current = access_types->get_next_element();
  }

  return retval;
}

void
IIRScram_Allocator::_type_check( set<IIR_TypeDefinition> * ){
  // Don't need to do anything...
}

void
IIRScram_Allocator::_publish_cc_lvalue( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_Allocator::_publish_cc" );
  
  _cc_out << " *(new " << 
  get_type_mark()->_get_cc_type_name();
  _cc_out << "(ObjectBase::VARIABLE";
  if (((get_type_mark()->_is_array_type() == TRUE) ||
       (get_type_mark()->_is_record_type() == TRUE)) &&
      (get_type_mark()->_is_access_type() == FALSE)) {
    get_type_mark()->_publish_cc_object_type_info( _cc_out );
    _cc_out << ", ";
    get_type_mark()->_publish_cc_resolution_function_id( _cc_out );
    get_type_mark()->_publish_cc_constructor_args( _cc_out );
    if (get_type_mark()->_is_unconstrained_array_type() == TRUE) {
      
      _cc_out << ", ";
      get_value()->_publish_cc_range( _cc_out );
    }
  }
  if(get_value() != NULL){
    _cc_out << ", ";
    get_value()->_publish_cc_initialization_value( _cc_out );
  }
  else {// don't know if this is entirly correct
    if(get_type_mark()->_is_scalar_type() == TRUE) {
      _cc_out << ", " << 
      get_type_mark()->_get_cc_type_name();
      _cc_out << "::LEFT(";
      get_type_mark()->_publish_cc_object_type_info(_cc_out, FALSE);
      _cc_out << ")";
    }
  }
  _cc_out << "))";
}

void 
IIRScram_Allocator::_add_decl_into_cgen_symbol_table(){
  if(get_value() != NULL){
    get_value()->_add_decl_into_cgen_symbol_table();
  }
}
  
void
IIRScram_Allocator::_publish_cc_initialization_value( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_Allocator::_publish_cc_initialization_value" );
  
  if(get_value() != NULL){
    //_cc_out << ", ";
    if ((get_value()->get_subtype()->_is_scalar_type() == TRUE) ||
	(this->get_subtype()->_is_access_type() == TRUE) && 
	(get_value()->_is_string_literal() == FALSE)) {
      _cc_out << "*(";
      get_value()->_publish_cc_state_object_init( _cc_out );
      _cc_out << ")";
    }
	else {
	  get_value()->_publish_cc_state_object_init( _cc_out );
	}
  }
  else {
    _cc_out << " *(";
    _cc_out << " new " << get_type_mark()->_get_cc_type_name();
    _cc_out << "(ObjectBase::VARIABLE";
    if(get_type_mark()->_is_array_type() == TRUE) {
      get_type_mark()->_publish_cc_constructor_args( _cc_out );
    }
    _cc_out << "))";
  }
}

IIR_Boolean 
IIRScram_Allocator::_is_resolved(){
  ASSERT( get_type_mark() != NULL );
  return get_type_mark()->_is_resolved();
}

IIR_Boolean 
IIRScram_Allocator::_is_globally_static_primary(){
  ASSERT( get_type_mark() != NULL );
  return get_type_mark()->_is_globally_static();
}

visitor_return_type *IIRScram_Allocator::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_Allocator(this, arg);
};
