
// Copyright (c) 2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Author: Harish Venkataramani venkath@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRScram_BreakElement.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Declaration.hh"
#include "set.hh"
#include "resolution_func.hh"
#include "error_func.hh"

IIRScram_BreakElement::~IIRScram_BreakElement() { }
    
void
IIRScram_BreakElement::_publish_vhdl(ostream &_vhdl_out) {
  get_quantity_name()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " => " ;
  get_expression()->_publish_vhdl(_vhdl_out);
}  

void
IIRScram_BreakElement::_publish_cc(published_file &_cc_out) {
  ASSERT(get_quantity_name() != NULL);
  ASSERT(get_expression() != NULL);
  if ( get_quantity_name()->get_prefix() != NULL ) {
    _cc_out << "&";
    get_quantity_name()->get_prefix()->_publish_cc_lvalue(_cc_out);
    _cc_out << ", " ;
    _cc_out << "break_expr_func_" << this << "  ";
    if(get_selector_quantity_name()!= NULL) {
      _cc_out << ", ";
      get_selector_quantity_name()->get_prefix()->_publish_cc_value(_cc_out);
    }
    _cc_out << " );\n";
  }
}

void
IIRScram_BreakElement::_publish_cc_ams() {}
    
void
IIRScram_BreakElement::_type_check() {}
