
// Copyright (c) 1996-2002 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Umesh Kumar V.Rajasekaran
//          Narayanan Thondugulam
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIR_CaseStatementAlternativeByOthers.hh"
#include "published_file.hh"
#include "savant.hh"

IIRScram_CaseStatementAlternativeByOthers::~IIRScram_CaseStatementAlternativeByOthers() {}


void 
IIRScram_CaseStatementAlternativeByOthers::_publish_vhdl(ostream &_vhdl_out) {

  _vhdl_out << "when others";
  
  if (sequence_of_statements.first() != NULL) {
    _vhdl_out << " =>\n";
    sequence_of_statements._publish_vhdl(_vhdl_out);
  }
  else if (_get_currently_publishing_vhdl_unit() == CASE_STATEMENT) {
    _vhdl_out << " =>\n";
  }
}


void 
IIRScram_CaseStatementAlternativeByOthers::_publish_cc_lvalue( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_CaseStatementAlternativeByOthers::_publish_cc" );
  _cc_out << "else";
  _cc_out.start_block();
  sequence_of_statements._publish_cc( _cc_out );
  _cc_out.end_block();
}

ostream &
IIRScram_CaseStatementAlternativeByOthers::_print( ostream &os ){
  os << "others ";
  return os;
}


IIR*
IIRScram_CaseStatementAlternativeByOthers::_clone() {
  IIR_CaseStatementAlternativeByOthers *clone;
  clone = new IIR_CaseStatementAlternativeByOthers;
  IIRScram_CaseStatementAlternative::_clone(clone);

  return clone;
}

visitor_return_type *IIRScram_CaseStatementAlternativeByOthers::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_CaseStatementAlternativeByOthers(this, arg);
};
