#ifndef IIRSCRAM_CONCURRENT_SELECTED_SIGNAL_ASSIGNMENT_HH
#define IIRSCRAM_CONCURRENT_SELECTED_SIGNAL_ASSIGNMENT_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_ConcurrentSelectedSignalAssignment.hh"

class IIRScram_ConcurrentSelectedSignalAssignment : public IIRBase_ConcurrentSelectedSignalAssignment {
public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  IIR  *_transmute();
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);
  IIR *_clone();

#ifdef PROCESS_COMBINATION
  void _static_elaborate(IIR_ArchitectureDeclaration*, IIR_DeclarationList*,
			 char*);
#endif

  void _type_check();
  IIR_Boolean _is_resolved();

  IIR *_get_target();
  void _set_target( IIR * );
  
  IIR_DelayMechanism _get_delay_mechanism();
  void _set_delay_mechanism( IIR_DelayMechanism );
  
  IIR *_get_reject_time_expression();
  void _set_reject_time_expression( IIR * );

  IIR *_get_case_statement_expression();
  void _set_case_statement_expression( IIR * );

  IIR_SignalDeclaration *_get_guard_signal(){ return _my_guard_signal; }
  void _set_guard_signal( IIR_SignalDeclaration *gs ){ _my_guard_signal =  gs; }

protected:
  IIRScram_ConcurrentSelectedSignalAssignment(){ _my_guard_signal = NULL; }
  virtual ~IIRScram_ConcurrentSelectedSignalAssignment() = 0;
    
private:
  // These methods are used to transform our data into and out of case
  // statement alterntives.  They are used during the type checking,
  // should be during transmute, too.  The read method is used during type
  // checking to take a resolved list returned to us, and put it back into
  // the selected waveforms.
  IIR_CaseStatementAlternativeList *_build_alternative_list();
  void _read_alternative_list(  IIR_CaseStatementAlternativeList * );
  void _type_check_expression_and_choices();
  void _type_check_target_and_waveforms();
  
  IIR_SignalDeclaration *_my_guard_signal;
};
#endif
