
#ifndef IIRSCRAM_CONSTANT_INTERFACE_DECLARATION_HH
#define IIRSCRAM_CONSTANT_INTERFACE_DECLARATION_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Timothy J. McBrayer 
//          Krishnan Subramani  
//          Umesh Kumar V. Rajasekaran 
//          Narayanan Thondugulam 

#include "IIRBase_ConstantInterfaceDeclaration.hh"

class IIR_List;

class IIRScram_ConstantInterfaceDeclaration : public IIRBase_ConstantInterfaceDeclaration {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl_decl(ostream &);
  void _publish_cc_decl( published_file &_cc_out );

  void _publish_cc_elaborate( published_file &_cc_out );
  void _publish_cc_elaborate_as_pointers( published_file &_cc_out,
					  IIR_Boolean publishDefinition = TRUE);
  declaration_type _get_type();
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_headers( published_file &_cc_out );
  void _publish_cc_state_object_init( published_file & ){}
  const string _get_cc_object_type();
  void _publish_cc_universal_value( published_file &_cc_out );

  void _publish_cc_ams_function(published_file &);
  void _set_stmt_node_index(IIR_Int32 *, bool, bool&);
  void _build_generic_parameter_set(set<IIR_Declaration> *);
  const string _get_cc_kernel_type();
  
  IIR_Boolean _is_static_expression() { return TRUE; }
  IIR_Boolean _is_constant() { return TRUE; }

  IIR *_clone();

  void _type_check( IIRScram_InterfaceDeclaration::_InterfaceListType );

protected:
  IIRScram_ConstantInterfaceDeclaration() {}
  virtual ~IIRScram_ConstantInterfaceDeclaration() = 0;
    
private:
  IIR_Int32 _stmt_node_index;
};
#endif

