// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRScram_FloatingPointLiteral64.hh"
#include "IIR_FloatingSubtypeDefinition.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_FloatingPointLiteral64::~IIRScram_FloatingPointLiteral64() {}

void 
IIRScram_FloatingPointLiteral64::_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << value();
}


void 
IIRScram_FloatingPointLiteral64::_publish_cc_lvalue( published_file &_cc_out ) {
  _cc_out << get_subtype()->_get_cc_type_name();
  _cc_out << "(ObjectBase::VARIABLE,";
  _publish_cc_universal_value( _cc_out );
  get_subtype()->_publish_cc_object_type_info( _cc_out );
  _cc_out << ")";
}

void
IIRScram_FloatingPointLiteral64::_publish_cc_universal_value( published_file &_cc_out ) {
  _cc_out << "UniversalReal(" << value() << ")";
}

void 
IIRScram_FloatingPointLiteral64::_publish_cc_value( published_file &_cc_out ) {
  _publish_cc_data( _cc_out );
}

void 
IIRScram_FloatingPointLiteral64::_publish_cc_data( published_file &_cc_out ) {
  _cc_out << value();
}


visitor_return_type *
IIRScram_FloatingPointLiteral64::_accept_visitor( node_visitor *visitor, 
						  visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_FloatingPointLiteral64(this, arg);
};
