#ifndef IIRSCRAM_INDEXED_NAME_HH
#define IIRSCRAM_INDEXED_NAME_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_IndexedName.hh"

template <class type> class set;
class IIR_Declaration;
class IIR_SliceName;
class IIR_PortList;
class IIR_GenericList;

class IIRScram_IndexedName : public IIRBase_IndexedName {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  virtual ~IIRScram_IndexedName() = 0;

  void _publish_vhdl(ostream &);
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_data( published_file &_cc_out );
  void _publish_cc_bounds( published_file &_cc_out );
  void _publish_cc_range( published_file &_cc_out );
  void _publish_cc_subprogram_arg( published_file &_cc_out );
  void _publish_cc_declarator( published_file &_cc_out );
  void _publish_cc_name_elaborate( published_file &_cc_out );
  void _publish_cc_object_name( published_file &_cc_out );
  void _publish_cc_wait_data( published_file &_cc_out );
  const string _get_cc_kernel_type();
  void _publish_cc_index_name_as_for_loop( published_file &_cc_out );
  IIR *_get_cc_instantiated_unit();

  void _get_list_of_input_signals( set<IIR> *list );  
  void _add_decl_into_cgen_symbol_table();

  /** This method returns the declaration of the indexed name.  If the
      prefix is a declaration, returns it, or else, gets the declaration of
      the prefix recursively. */
  IIR_Declaration* _get_prefix_declaration();

  IIR_Declaration* _get_package_declaration();

  set<IIR_Declaration> *_symbol_lookup();
  set<IIR_Declaration> *_symbol_lookup(set<IIR_Declaration> *);
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean(IIR::*constraint_function)()=0);
  set<IIR_TypeDefinition> *_get_rval_set( set<IIR_Declaration> *, 
					  IIR_Boolean (IIR::*constraint_function)()=0);
  
  /** This has to return a set because we can't always precisely determine
      the type without context... */
  set<IIR_TypeDefinition> *_return_type_given_prefix_declaration( IIR_Declaration *prefix_decl );

  IIR_TypeDefinition *_get_name_type();

  IIR_Boolean _is_resolved();
  IIR_Boolean _is_signal();
  IIR_Boolean _is_variable();
  IIR_Boolean _is_resolved_signal();
  IIR_Boolean _is_readable();
  IIR_Boolean _is_writable();
  IIR_Boolean _is_entity_decl();
  IIR_Boolean _is_interface();

  /** Assuming we have an array type (which gets asserted), is this an
      array access (returns TRUE) or a slice? */
  IIR_Boolean _is_array_access();

  IIR *_semantic_transform( set<IIR_TypeDefinition> *context_set );
  IIR *_rval_to_decl( IIR_TypeDefinition * );
  IIR *_rval_to_decl( IIR_Declaration *, IIR_TypeDefinition * );
  IIR_Declaration *_determine_decl_in_set( set<IIR_Declaration> *, IIR_TypeDefinition * );

  void _type_check( set<IIR_TypeDefinition> * );

  ostream &_print( ostream & );

  IIR *_get_suffix();
  void _set_suffix(IIR *suffix);

  void _set_my_rval( IIR_TypeDefinition * );
  IIR_TypeDefinition *_get_my_rval( );
  IIR_TypeDefinition *get_subtype( );

  void _set_passed_through_out_port(IIR_Boolean);
  void _publish_cc_elaborate( published_file &_cc_out );
  IIR *_clone();

  // This is for type checking.  Assume this indexed name is a
  // function call, and create an IIR_FunctionCall if it really is.
  // Return NULL if it's not.
  IIR *_process_as_function_call( set<IIR_TypeDefinition> *context_set );

  // Same as above, but for a type conversion...
  IIR *_process_as_type_conversion( set<IIR_TypeDefinition> * );

  // (See IIRScram.hh for description)
  IIR_Declaration *_find_formal_declaration();

  IIR_GenericList *_get_generic_list();
  IIR_PortList *_get_port_list();

  set<IIR_Declaration> *_get_implicit_declarations(){ return _implicit_decls; }
  void _set_implicit_declarations( set<IIR_Declaration> *id ){ _implicit_decls = id; };

  IIR_Boolean _is_globally_static_primary();

  // Methods needed to check and publish attributes on indexed names
  
  IIR_Boolean _is_published_attribute_in_state(SignalAttribute);
  IIR_Boolean _is_published_attribute_in_constructor(SignalAttribute);
  IIR_Boolean _is_published_attribute_in_initstate(SignalAttribute);
  void _add_published_attribute_in_state(SignalAttribute);
  void _add_published_attribute_in_constructor(SignalAttribute);
  void _add_published_attribute_in_initstate(SignalAttribute);

  IIR_Mode _get_mode();

protected:
  IIRScram_IndexedName(){
    _been_transformed = FALSE;
    _my_rval = NULL;
    _implicit_decls = NULL;
    _my_rval_set = NULL;
    _have_rval_set = FALSE;
  }
    
private:
  // Same as above, but for an array...
  IIR *_process_as_array( set<IIR_TypeDefinition> * );
  // Same as above, but for a slice...
  IIR *_process_as_slice( set<IIR_TypeDefinition> * );

  set<IIR_TypeDefinition> *_my_type_given_array_prefix_type( IIR_TypeDefinition * );

  IIR_TypeDefinition *_my_rval;

  IIR_SliceName *_build_slice( IIR_TypeDefinition * );

  set<IIR_TypeDefinition> *_get_array_prefixes();

  void _set_index( int, IIR * );
  IIR *_get_index( int );

  IIR_Int32 _get_num_indexes();

  // This flag tells us when calculating rvals whether we need to consider
  // that this node might represent a function call.
  IIR_Boolean _been_transformed;
  set<IIR_Declaration> *_implicit_decls;
  set<IIR_TypeDefinition> *_my_rval_set;
  IIR_Boolean _have_rval_set;
};
#endif
