#ifndef IIRSCRAM_LAST_EVENT_ATTRIBUTE_HH
#define IIRSCRAM_LAST_EVENT_ATTRIBUTE_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Umesh Kumar V. Rajasekaran  urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_LastEventAttribute.hh"

class IIRScram_LastEventAttribute : public IIRBase_LastEventAttribute {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  IIR_Boolean _is_signal(){ return FALSE; }
  IIR_Boolean _is_readable();
  IIR_TypeDefinition *get_subtype();

  IIR_TextLiteral *_build_attribute_name();

  IIR_Declaration *_get_implicit_declaration( const string &decl_name, 
					      IIR_TypeDefinition *decl_type );

  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_necessary_decl_in_state( published_file &_cc_out );
  void _publish_cc_name_in_caps( published_file &_cc_out );
  void _publish_cc_attrib_type( published_file &_cc_out );
  void _publish_cc_necessary_decl_init( published_file &_cc_out );
  void _publish_cc_necessary_copying( published_file &_cc_out );

  void _publish_cc_read_or_write( published_file &_cc_out,
				  const string &fName, 
				  const string &sName);

  void _publish_cc_init_val( published_file &_cc_out );
  void _publish_cc_elaborate( published_file &_cc_out );
  void _publish_cc_sigtype( published_file &_cc_out );
  void _publish_cc_state_object_init( published_file &_cc_out );
  void _publish_cc_init( published_file &_cc_out );
  virtual IIR *_clone();

  IIR_Boolean _is_lastevent_attribute() { return TRUE; }
  IIR_Boolean _is_function_attribute(){ return TRUE; }

protected:
  IIRScram_LastEventAttribute() {}
  virtual ~IIRScram_LastEventAttribute() = 0;
    
private:
};
#endif









