
#ifndef IIRSCRAM_MONADIC_OPERATOR_HH
#define IIRSCRAM_MONADIC_OPERATOR_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Krishnan Subramani  
//          Timothy J. McBrayer 

#include "IIRBase_MonadicOperator.hh"
class IIR_AboveAttribute;

class IIRScram_MonadicOperator : public IIRBase_MonadicOperator {

public:
  IIR  *_transmute();

  IIR_Boolean _is_readable();
  IIR_Boolean _is_resolved();

  virtual IIR *_rval_to_decl( IIR_TypeDefinition *my_rval );

  void _publish_cc_wait_data( published_file &_cc_out );
  void _publish_cc_rvalue( published_file &_cc_out );
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_headers( published_file &_cc_out );
  void _publish_cc_ams_function(published_file &);
  void _publish_cc_ams_function_call_in_simult_stmt(published_file &);
 
  void _get_list_of_input_signals( set<IIR> *list );
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);
  void _build_generic_parameter_set(set<IIR_Declaration> *);
  IIR *_clone();

  virtual void _add_decl_into_cgen_symbol_table();
  virtual void _publish_cc_ams_operator_name(published_file &);

  void _publish_vhdl(ostream &);
  IIR_Boolean _is_static_expression();
  IIR_Boolean _is_operator();
  IIR_Boolean _is_locally_static_primary();
  IIR_Boolean _is_monadic_operator() {return TRUE;}

  void _set_stmt_qty_index(IIR_Int32 *, set<IIR_Declaration> *);
  void _set_stmt_signal_index(IIR_Int32 *, set<IIR_Declaration> *);
  virtual void _flush_stmt_index();

  IIR_Boolean _is_above_attribute_found();
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);
  
protected:
  IIR_Int32 _get_num_args(){ return 1; }  
  IIR_AssociationList *_build_argument_list();

  IIRScram_MonadicOperator() {};
  virtual ~IIRScram_MonadicOperator() = 0;

  const string _get_function_name() const;

  void _type_check_operands( );
    
private:
};
#endif
