
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.
 
// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 
// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.
  
// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.
 
// Authors: Sivakumar Gowrisankar             gowriss@ececs.uc.edu
//          Vinod Chamarty                    chamarv@ececs.uc.edu
//          Vasudevan Shanmugasundaram

#include "savant.hh"
#include "IIR_NatureDefinition.hh"
#include "IIRScram_NatureDefinition.hh"
#include "IIR_Declaration.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_Identifier.hh"
#include "StandardPackage.hh"
#include <stdlib.h>

using std::cerr;

IIRScram_NatureDefinition::~IIRScram_NatureDefinition() {}

void
IIRScram_NatureDefinition::_publish_vhdl(ostream& _vhdl_out) {
  if(_get_declaration() != NULL) {
    _get_declaration()->_publish_vhdl(_vhdl_out);
  } 
  else {
    ASSERT(get_base_type() != NULL);
    get_base_type()->_publish_vhdl(_vhdl_out);
  }
}

const string
IIRScram_NatureDefinition::_get_cc_type_name(){
  string retval;

  if( _is_scalar_type() == TRUE ) {
    retval = _get_cc_kernel_type();
  }
  else {
    if (_is_array_type() == TRUE) {
      retval = "ArrayNature";
    }
    else {
      cerr << "Error - IIRScram_NatureDefinition::_publish_cc_type_name(ostream &) encountered an unknown/unhandled type.\n";
      abort();
    }
  }

  return retval;
}

IIR_TextLiteral *
IIRScram_NatureDefinition::_get_declarator(){
  if( _get_declaration() != NULL ){
    return _get_declaration()->_get_declarator();
  }
  else {
    char *string = "<ANONYMOUS>";
    return IIR_Identifier::get( string, strlen( string ) );
  }
}

// This empty function is required to get things compiled.  However since
// the function is declared virtual, inherited class functions gets
// executed.
IIR_TerminalDeclaration *
IIRScram_NatureDefinition::get_reference_terminal() {
  _report_undefined_scram_fn("get_reference_terminal()");
  return  NULL;
}

IIR_TypeDefinition*
IIRScram_NatureDefinition::_get_final_subtype(){
  _report_undefined_scram_fn("_get_final_subtype()");
  return  NULL;
}

void
IIRScram_NatureDefinition::_set_resolution_function( IIR_FunctionDeclaration * ){
  _report_undefined_scram_fn("_set_resolution_function()");
}

void 
IIRScram_NatureDefinition::_set_element_subtype( IIR_NatureDefinition * ){
  _report_undefined_scram_fn("_set_element_subtype(IIR_NatureDefinition *)");
}

IIR_TypeDefinition *
IIRScram_NatureDefinition::_get_element_subtype(){
  _report_undefined_scram_fn("_get_element_subtype()");
  return NULL;
}

