// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Umesh Kumar V.  Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRScram_PathNameAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_ArraySubtypeDefinition.hh"
#include "StandardPackage.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_PathNameAttribute::~IIRScram_PathNameAttribute() {}

void 
IIRScram_PathNameAttribute::_publish_vhdl(ostream &_vhdl_out) {
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'PATH_NAME ";
}


void 
IIRScram_PathNameAttribute::_publish_cc_lvalue( published_file &_cc_out ) {
  _cc_out << "path_name(";
  get_prefix()->_publish_cc_lvalue( _cc_out );
  _cc_out << ")";
}


IIR_TextLiteral *
IIRScram_PathNameAttribute::_build_attribute_name() {
  char *name = "pathname";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_PathNameAttribute::get_subtype(){
  return StandardPackage::get_string_type();
}

IIR_Declaration *
IIRScram_PathNameAttribute::_get_implicit_declaration( const string &name,
						       IIR_TypeDefinition *type ){
  return _build_constant_declaration( name, type );
}

visitor_return_type *
IIRScram_PathNameAttribute::_accept_visitor( node_visitor *visitor, 
					     visitor_argument_type *arg ){
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_PathNameAttribute(this, arg);
}
