
#ifndef IIRSCRAM_PROCESS_STATEMENT_HH
#define IIRSCRAM_PROCESS_STATEMENT_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Malolan Chetlur    
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam
//          Swaminathan Subramanian

#include "IIRBase_ProcessStatement.hh"
class IIR_WaitStatement;
class IIR_AboveAttribute;
#include "set.hh"
#include "symbol_table.hh"

class IIRScram_ProcessStatement : public IIRBase_ProcessStatement {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_cc( published_file &_cc_out );
  /** Publshes the warped state class for this process. */
  void _publish_cc_state();
  void _publish_cc_file_open( published_file &_cc_out );
  void _publish_cc_extern_declarations( published_file &_cc_out );
  void _publish_cc_file_declarations( published_file &_cc_out );

  void _publish_cc_binding_name( ostream &_cc_out );
  const string _get_cc_binding_name();

  virtual void _publish_createNetInfo( published_file &_cc_out );
  void _add_declarations_in_initializations();
  IIR_Boolean _publish_cc_type_info( published_file &_cc_out, IIR_Boolean = FALSE );
  void _publish_cc_extern_type_info( published_file &_cc_out );
  void _publish_cc_instantiate_call( published_file &_cc_out );

#ifdef PROCESS_GRAPH
  void _publish_cc_driver_info( published_file &_cc_out );
#endif

  virtual void _type_check();
  virtual set<IIR_Declaration> *_find_declarations( IIR_Name * );
  IIR *_clone();

#ifdef PROCESS_COMBINATION
  void _static_elaborate( IIR_ArchitectureDeclaration*, 
			  IIR_DeclarationList*, char* );
  bool _convert_to_TWF();
#endif

  void _get_list_of_input_signals( set<IIR> *list );
  void _get_signal_source_info( set<IIR> *siginfo );
  void _build_wait_list();

  /** This function publishes all the implicit declarations of the
      declarations visible in the process statement part. */
  void _publish_cc_implicit_declarations( published_file &_cc_out,
					  IIR_Declaration *decl );

  dl_list<IIR_WaitStatement> _wait_stmt_list;
  symbol_table cgen_sym_tab;

  void _publish_cc_concurrent_stmt_init( published_file &_cc_out,
					 IIR_DeclarationList *decl_list );

  /** Publishes an include for this process. */
  virtual void _publish_cc_include( published_file &_cc_out ){ _publish_cc_include( _cc_out, 
										    "" ); }

  /** Returns a string holding the process' name wrt to C++ publishing. */
  const string _get_cc_process_class() const;
  const string _get_cc_state_class() const;

  set<IIR_AboveAttribute> _above_attribute_set;
  void _publish_cc_ams_tick_above_info(published_file&);
  void _publish_cc_ams_tick_above_function_prototype(published_file&);
  void _publish_cc_ams_tick_above_function_body(published_file&);

  void _publish_cc_ams_break_function_include(published_file &);
  void _publish_cc_ams_breakExpression_function_body(published_file &);
  void _publish_cc_ams_breakExpression_function_prototype(published_file &);

protected:
  IIRScram_ProcessStatement();
  virtual ~IIRScram_ProcessStatement() = 0;
    
private:
  /** The VHDL objects namely the signal and variable has to be specified
      while declaring the type. The type of object namely the signal or
      Variable is specified in the constructor of the state classes that is
      generated. */
  void _publish_cc_state_objects_init( published_file &_cc_out, set<IIR_Declaration> * );
  /** Publishes the includes that the state class needs. */
  void _publish_cc_headers( published_file &_cc_out );
  /** Publishes the definition of the state class. */
  void _publish_cc_state_class( published_file &_cc_out );
  /** Publishes the constructor for the state class. */
  void _publish_cc_constructor( published_file &_cc_out );
  void _publish_cc_initstate( published_file &_cc_out );
  void _publish_cc_cleanstate( published_file &_cc_out );
  void _publish_cc_locatesignal( published_file &_cc_out );
  //  void _publish_cc_ostream_operator( published_file &_cc_out );
  void _publish_cc_print( published_file &_cc_out );
  void _publish_cc_operator_equalto( published_file &_cc_out );
  void _publish_cc_wait_init( published_file &_cc_out );
  void _publish_cc_composite_resolved_signal_init( published_file &_cc_out );

  /** Helper for the other _publish_cc_include methods. */
  virtual void _publish_cc_include( published_file &_cc_out,
				    const string &to_insert );

  /** Returns the design unit name.  Currently this is a frightening
      function that relies heavily on globals and side effects. */
  const string _get_design_unit_name();

  void _publish_cc_read_or_write( published_file &_cc_out, const string &, const string & );

  /** Publishes an include for this process' state. */
  virtual void _publish_cc_include_state( published_file &_cc_out );

  
  /** The following function clears the newly set code generation
      attributes in any of the previous process Statements.  code
      generation attributes are the data members in the IIRScram* nodes.
      NEED: The Signals and other objects that are defined in Architecture
      decls are visible throughout. Certain attributes are added to such
      nodes While generating code for process Statements. They should be
      cleared while publishing a new process Statement. */
  void _clear();

};
#endif
