
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Harish Venkataramani venkath@ececs.uc.edu

#include "IIRScram_SimultaneousIfStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_Label.hh"
#include "IIR_Elsif.hh"
#include "resolution_func.hh"
#include "StandardPackage.hh"
#include "set.hh"
#include "published_file.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"

IIRScram_SimultaneousIfStatement::~IIRScram_SimultaneousIfStatement() {}

IIRScram_SimultaneousIfStatement::IIRScram_SimultaneousIfStatement() {}

IIR_Boolean
IIRScram_SimultaneousIfStatement::_is_simultaneous_statement() {
return TRUE ;
}

void
IIRScram_SimultaneousIfStatement::_publish_vhdl(ostream &_vhdl_out) { 
  _publish_vhdl_stmt_label(_vhdl_out);
  _vhdl_out << " if ( ";
  get_condition()->_publish_vhdl(_vhdl_out);
  _vhdl_out <<" )" ;
  _vhdl_out << " use\n " ;
  if ( then_statement_list.num_elements() != 0 ) {
    then_statement_list._publish_vhdl(_vhdl_out);
  }
  if( get_elsif() != NULL ) {
    get_elsif()->_publish_vhdl(_vhdl_out);
  }
  if ( else_statement_list.num_elements() != 0 ) {
    _vhdl_out << " else\n ";
    else_statement_list._publish_vhdl(_vhdl_out);
  }
  _vhdl_out << " end use " ;
  _vhdl_out << ";\n " ;
}

void
IIRScram_SimultaneousIfStatement::_publish_cc(published_file &_cc_out) {}

void
IIRScram_SimultaneousIfStatement::
_publish_cc_characteristic_expressions(IIRScram_ArchitectureStatement::
				       SimultaneousIfPublishingPart current_part,
                                       published_file &_cc_out) {
  
  IIR_ArchitectureStatement *current_stmt = NULL ;
  IIR_Int32 temp = _unique_qtys.num_elements();
  IIR_Declaration *current_set_qty = NULL;
  IIR_Declaration *current_set_signal = NULL;
  
  _cc_out << "  equation = new condition(\"";
  _get_label()->_publish_cc_lvalue(_cc_out);
  _cc_out << "\", ";
  _get_label()->_publish_cc_lvalue(_cc_out);
  _cc_out << ", ";
  _cc_out << _unique_qtys.num_elements();
  if(_unique_qtys.num_elements() > 0 ) {
    _cc_out << ", ";
    for( current_set_qty = _unique_qtys.get_element();
	 current_set_qty != NULL;
	 current_set_qty = _unique_qtys.get_next_element() ) {
      if( temp > 0 ) {
	_cc_out << "&(";
	current_set_qty->_publish_cc_lvalue(_cc_out);
	_cc_out << ") ";
	if( temp > 1 ) {
	  _cc_out << ", ";
	}
	temp--;
      }
    }
  }
  _cc_out << " );" << NL();
  _cc_out << "  equation->setEnclosingBlock(this);" << NL();
  for(current_set_signal = _unique_signals.get_element();
      current_set_signal != NULL;
      current_set_signal = _unique_signals.get_next_element() ) {
    _cc_out << "  equationSignal = new signalDS(&(";
    current_set_signal->_publish_cc_elaborate(_cc_out);
    _cc_out << "), (";
    current_set_signal->_publish_cc_lvalue(_cc_out);
    _cc_out << ") );\n";
    _cc_out << "  equation->addSignal(equationSignal);\n";
  }
  switch(current_part) {
  case IIRScram_ArchitectureStatement::None: {
    _cc_out << "add(equation);" << NL() << NL() << "  ";
  }
    break;
  case IIRScram_ArchitectureStatement::IF_PART: {
    _cc_out << "add(equation, YES);" << NL() << NL() << "  ";
  }
  case IIRScram_ArchitectureStatement::ELSE_PART: {
    _cc_out << "add(equation, NO);" << NL() << NL() << "  ";
  }
    break;
  default: {
    cerr << "Wrong enumeration for publishing simultaneous "
         << "if/elsif statement!!" << endl;
    cerr << "Aborting VHDL-AMS to C++ code generation ..." << endl;
    abort();
  }
    break;
  }
  _cc_out << "nextCondition(equation);" << NL() << "  ";
  SimultaneousIfPublishingPart stmt_publishing_part =
    IIRScram_ArchitectureStatement::None;
  for( current_stmt = then_statement_list.first();
       current_stmt != NULL;
       current_stmt = then_statement_list.successor(current_stmt) ) {
    stmt_publishing_part = IIRScram_ArchitectureStatement::IF_PART;
    current_stmt->_publish_cc_characteristic_expressions(stmt_publishing_part,_cc_out);
  }
  stmt_publishing_part = IIRScram_ArchitectureStatement::ELSE_PART;
  if(get_elsif() != NULL) {
    get_elsif()->_publish_cc_characteristic_expressions(stmt_publishing_part,_cc_out);
  }
  for( current_stmt = else_statement_list.first();
       current_stmt != NULL;
       current_stmt = else_statement_list.successor(current_stmt) ) {
    current_stmt->_publish_cc_characteristic_expressions(stmt_publishing_part,_cc_out);
  }
  IIR_SimultaneousElsif *temp1 = get_elsif();
  IIR_SimultaneousElsif *temp2 = NULL;
  if( temp1 != NULL) {
    _cc_out << "  removeCondition();" << NL();
    temp2 = get_elsif()->get_else_clause();
    while(temp2 != NULL) {
      _cc_out << "  removeCondition();" << NL();
      temp2 = temp2->get_else_clause();
    }
  }
  _cc_out << "  removeCondition();" << NL() ;
}

void
IIRScram_SimultaneousIfStatement::_publish_cc_ams_function_prototype(published_file &_cc_out) {

  IIR_ArchitectureStatement *current_stmt = NULL;
  
  _cc_out << NL() << "int" << NL();
  _get_label()->_publish_cc_lvalue(_cc_out);
  _cc_out << "( component *, double * );" << NL();
  for( current_stmt = then_statement_list.first();
       current_stmt != NULL;
       current_stmt = then_statement_list.successor(current_stmt) ) {
    (static_cast <IIR_SimultaneousStatement *>(current_stmt))->_publish_cc_ams_function_prototype(_cc_out);
  }
  if(get_elsif() != NULL) {
    get_elsif()->_publish_cc_ams_function_prototype(_cc_out);
  }
  for( current_stmt = else_statement_list.first();
       current_stmt != NULL;
       current_stmt = else_statement_list.successor(current_stmt) ) {
    (static_cast <IIR_SimultaneousStatement *>(current_stmt))->_publish_cc_ams_function_prototype(_cc_out);
  }
}

void
IIRScram_SimultaneousIfStatement::_publish_cc_ams_function_body(published_file &_cc_out) {
  IIR_ArchitectureStatement *current_stmt = NULL;
  IIR *condition = get_condition();
  IIR_Declaration *current_signal = NULL;
  PublishedUnit _saved_publishing_unit = _get_currently_publishing_unit();
  _set_currently_publishing_unit(SIMULTANEOUS_IF);
  _stmt_qty_index = 0;
  _stmt_signal_index = 0;

  condition->_set_stmt_qty_index(&_stmt_qty_index, &_unique_qtys);
  condition->_set_stmt_signal_index(&_stmt_signal_index, &_unique_signals);
  condition->_build_generic_parameter_set(&_unique_generic_constants);

  _cc_out << NL() << "int" << NL();
  _get_label()->_publish_cc_lvalue(_cc_out);
  _cc_out << "(component *currentCondition, double *qty ) {" << NL();
  _cc_out << "  currentCondition = currentCondition;\n"
          << "  qty = qty;\n";
  
  for(current_signal = _unique_signals.get_element();
      current_signal != NULL;
      current_signal = _unique_signals.get_next_element()) {
    _cc_out << "  " << current_signal->_get_cc_type_name() << "  ";
    current_signal->_publish_cc_lvalue(_cc_out);
    _cc_out << "(ObjectBase::VARIABLE, currentCondition->locateSignal(";
    _cc_out << current_signal->_get_stmt_signal_index() << "));" << NL();
  }
  std::cout << " am coin here "<<std::endl;
  _cc_out << "  return ( ( SAVANT_BOOLEAN_TRUE == ";
  condition->_publish_cc_ams_function(_cc_out);
  _cc_out << " ) ? 1 : 0 );" << NL();
  _cc_out << "}" << NL() ;
  
  condition->_flush_stmt_index();
  
  _set_currently_publishing_unit(_saved_publishing_unit);
   
  for( current_stmt = then_statement_list.first();
       current_stmt != NULL;
       current_stmt = then_statement_list.successor(current_stmt) ) {
    (static_cast <IIR_SimultaneousStatement *>(current_stmt))->_publish_cc_ams_function_body(_cc_out);
  }
  if(get_elsif() != NULL){
    get_elsif()->_publish_cc_ams_function_body(_cc_out);
  }
  for( current_stmt = else_statement_list.first();
       current_stmt != NULL;
       current_stmt = else_statement_list.successor(current_stmt) ) {
    (static_cast <IIR_SimultaneousStatement *>(current_stmt))->_publish_cc_ams_function_body(_cc_out);
  }
}

void
IIRScram_SimultaneousIfStatement::_type_check(){
  IIR *new_condition = _type_check_and_resolve_boolean_condition( get_condition() );

  ASSERT( new_condition != NULL );
  ASSERT( new_condition->_is_resolved() == TRUE );
  set_condition( new_condition );
  set<IIR_TypeDefinition> *bool_rvals = 
    new set<IIR_TypeDefinition>((IIR_TypeDefinition *)StandardPackage::get_boolean_type());
  if( get_elsif() != NULL ){
    get_elsif()->_type_check( bool_rvals );
  }
}
