
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Malolan Chetlur    
//          Krishnan Subramani 
//          Umesh Kumar V. Rajasekaran
//          Radharamanan Radhakrishnan
//          Narayanan Thondugulam
//          Swaminathan Subramanian
//	    Magnus Danielson	cfmd@swipnet.se

#include "IIR_EnumerationSubtypeDefinition.hh"
#include "IIR_ArrayTypeDefinition.hh"
#include "IIR_FloatingSubtypeDefinition.hh"
#include "IIR_FunctionDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIR_Name.hh"
#include "IIR_RangeTypeDefinition.hh"
#include "IIR_StringLiteral.hh"
#include "IIR_Identifier.hh"
#include "IIR_ConstantInterfaceDeclaration.hh"
#include "IIR_AccessSubtypeDefinition.hh"
#include "IIR_ProcessStatement.hh"
#include "symbol_table.hh"
#include "StandardPackage.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "savant.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"

IIRScram_TypeDefinition::~IIRScram_TypeDefinition() {}

IIRScram_TypeDefinition::IIRScram_TypeDefinition(){
  my_attribute = NULL;
}

void
IIRScram_TypeDefinition::_publish_vhdl(ostream &_vhdl_out) {
  if( _get_declaration() != NULL ){
    _get_declaration()->_publish_vhdl(_vhdl_out);
  } 
  else {
    ASSERT( get_base_type() != NULL );
    get_base_type()->_publish_vhdl(_vhdl_out);
  }
}

set<IIR_Declaration> *
IIRScram_TypeDefinition::_find_declarations( IIR_Name * ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_find_declarations( IIR_Name * )");  
  return NULL;
}

set<IIR_Declaration> *
IIRScram_TypeDefinition::_find_declarations( IIR_TextLiteral * ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_find_declarations( IIR_TextLiteral * )");  
  return NULL;
}

IIR_Boolean
IIRScram_TypeDefinition::_is_bit_type() {
  return FALSE;
}

IIR_Boolean
IIRScram_TypeDefinition::_is_subtype_decl() {
  IIR_Declaration* type_decl = _get_declaration();
  if( type_decl != NULL ){
    return type_decl->_is_subtype_decl();
  }
  else {
    return FALSE;
  }
}

IIR_Boolean
IIRScram_TypeDefinition::_is_line_type() {
  if( _get_declaration() != NULL ){
    return ( 0 ==IIR_TextLiteral::_cmp(_get_declaration()->get_declarator(), "line") );
  }
  else {
    return FALSE;
  }
}

IIR_Boolean
IIRScram_TypeDefinition::_is_boolean_type() {
  return FALSE;
}

IIR_Boolean
IIRScram_TypeDefinition::_is_kernel_type() {
  if( (IIRScram_TextLiteral::_cmp(_get_declarator(), "integer") == 0)        ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "boolean") == 0)        ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "severity_level") == 0) ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "positive") == 0)       ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "character") == 0)      ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "real") == 0)           ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "time") == 0)           ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "natural") == 0)        ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "bit") == 0)            ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "side") == 0)           ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "width") == 0)          ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "delay_length") == 0)   ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "file_open_kind") == 0) ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "bit_vector") == 0)     ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "string") == 0)         ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "text") == 0)           ||
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "line") == 0)           ||  
      (IIRScram_TextLiteral::_cmp(_get_declarator(), "file_open_status") == 0)
      ) {
    return TRUE;
  }
  else {
    return FALSE;
  }
}

void
IIRScram_TypeDefinition::_publish_cc_left( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_left( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_universal_left( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_universal_left( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_bounds( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc_bounds" );
  _cc_out << "defaultInfo";
}

void
IIRScram_TypeDefinition::_publish_cc_right( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_right( _cc_out )");  
}

IIR_Boolean
IIRScram_TypeDefinition::_is_subtype() {
  return FALSE;
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::_get_bottom_base_type(){
  if( get_base_type() == NULL ){
    return (IIR_TypeDefinition *)this;
  }
  else{
    return get_base_type()->_get_bottom_base_type();
  }
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::_get_element_subtype(){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_get_element_subtype()");  
  return NULL;
}

IIR_ScalarTypeDefinition *
IIRScram_TypeDefinition::_get_index_subtype(){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_get_index_subtype()");  
  return NULL;
}

void  
IIRScram_TypeDefinition::_set_index_subtype( IIR_ScalarTypeDefinition *){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_set_index_subtype()");  
  abort();
}

void  
IIRScram_TypeDefinition::_set_element_subtype( IIR_TypeDefinition *){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_set_element_subtype()");  
  abort();
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::get_across(){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::get_across()");
  return NULL;
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::get_through(){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::get_through()");
  return NULL;
}

void
IIRScram_TypeDefinition::_publish_cc_array_info( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_array_info( _cc_out )");
}

void
IIRScram_TypeDefinition::_publish_cc_lvalue( published_file &_cc_out ) {
  _publish_cc_lvalue( _cc_out.get_stream() );
}

void
IIRScram_TypeDefinition::_publish_cc_lvalue( ostream &_cc_out ) {
  // SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc" );
  _cc_out << "Savant";
  _cc_out << *_get_declarator();
  _cc_out << "Type";
}

void
IIRScram_TypeDefinition::_publish_cc_class( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc_class" );

  _cc_out << "class ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << " : public ";
  _publish_cc_parent_type_name( _cc_out );
  _cc_out << " {\n";
  _cc_out << "public:\n ";
  if(_is_subtype_decl() == FALSE) {
    _publish_cc_data_members( _cc_out );
  }
  _publish_cc_decl_constructors( _cc_out );
  _publish_cc_decl_destructors( _cc_out );
  if((_is_scalar_type() == TRUE)&& (_is_access_type() != TRUE)) {
    _publish_cc_function_leftvalue( _cc_out );
  }
  if (_is_record_type() == TRUE) {
    _publish_cc_decl_operator_equalto( _cc_out );
  } else if(_is_array_type() == TRUE) {
    _publish_cc_decl_operator_equalto( _cc_out );
    _publish_cc_decl_operator_subscript( _cc_out );
  }
  
  _publish_cc_decl_type_attributes( _cc_out );
  _cc_out << "};\n";

  if (_has_access_type() == FALSE) {
    if ((_is_array_type() == TRUE) || (_is_record_type() == TRUE)) {
      _cc_out << "\n//The _event class...\n";
      _publish_cc_decl_event_class("_event");
      _cc_out << "\n//The _lastevent class...\n";
      _publish_cc_decl_event_class("_lastevent");
      _cc_out << "\n";
    }
  }
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::_get_parent_type(){
  IIR_TypeDefinition *retval = (IIR_TypeDefinition *)this;

  if( _is_subtype_decl() == TRUE && _is_enumeration_type() == FALSE ) {
    ASSERT(_get_type_mark() != NULL);
    retval = _get_type_mark();
  }
  else if( get_base_type() != NULL && get_base_type()->_is_anonymous() == FALSE ) {
    retval = get_base_type();
  }
  
  return retval;
}

void
IIRScram_TypeDefinition::_publish_cc_parent_type_name( published_file &_cc_out ) {
  //  SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc_parent_type_name" );
  if( _get_parent_type() != this ){
    _cc_out << _get_parent_type()->_get_cc_type_name();
  }
  else{
    _publish_cc_kernel_type( _cc_out );
  }
}

void
IIRScram_TypeDefinition::_publish_cc_function_leftvalue( published_file &_cc_out ) {
  string typeName;
  ostringstream typeStream;

  SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc_function_leftvalue" );

  switch(get_kind()){
  case IIR_INTEGER_SUBTYPE_DEFINITION: 
  case IIR_INTEGER_TYPE_DEFINITION:
    typeStream << "IntegerTypeInfo";
    break;
  case IIR_FLOATING_SUBTYPE_DEFINITION:
  case IIR_FLOATING_TYPE_DEFINITION:
    typeStream << "RealTypeInfo";
    break;
  case IIR_ENUMERATION_SUBTYPE_DEFINITION:
  case IIR_ENUMERATION_TYPE_DEFINITION:
    typeStream << "EnumerationTypeInfo";
    break;
  case IIR_PHYSICAL_SUBTYPE_DEFINITION:
  case IIR_PHYSICAL_TYPE_DEFINITION:
    typeStream << "PhysicalTypeInfo";
    break;

  default:
    break;
  }
  typeName = typeStream.str();
  _cc_out << "const VHDLData& leftValue(";
  _cc_out << typeName << " rInfo";
  _cc_out << ") {\n";
  _cc_out << "return ((";
  _publish_cc_kernel_type( _cc_out );
  _cc_out << "::";
  _cc_out << "LEFT(rInfo)).readVal());\n";
  _cc_out << "}\n";
}

// void
// IIRScram_TypeDefinition::_publish_cc_concatenation_operator_prototype( published_file &_cc_out ) {

//   SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc_concatenation_operator_prototype" );

//   _cc_out << "extern ";
//   _cc_out << _get_cc_type_name();
//   _cc_out << "\nsavantConcatenate(const ";
//   _cc_out << _get_cc_type_name();
//   _cc_out << "& lhs, const ";
//   _cc_out << _get_cc_type_name();
//   _cc_out << "& rhs);\n";

//   _cc_out << "extern ";
//   _cc_out << _get_cc_type_name();
//   _cc_out << "\nsavantConcatenate(const ";
//   _cc_out << _get_cc_type_name();
//   _cc_out << "& lhs, const ";
//   if (((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_is_scalar_type() == TRUE && ((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_is_kernel_type()==FALSE){
//     ((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_publish_cc_kernel_type( _cc_out );
//   }
//   else {
//     _cc_out << ((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_get_cc_type_name();
//   }
//   _cc_out << "& rhs);\n";

//   _cc_out << "extern ";
//   _cc_out << _get_cc_type_name();
//   _cc_out << "\nsavantConcatenate(const ";
//   if (((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_is_scalar_type() == TRUE && ((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_is_kernel_type() == FALSE){
//     ((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_publish_cc_kernel_type( _cc_out );
//   }
//   else {
//     _cc_out << ((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_get_cc_type_name();
//   }

//   _cc_out << "& lhs, const ";
//   _cc_out << _get_cc_type_name();
//   _cc_out << "& rhs);\n";

//   _cc_out << "extern ";
//   _cc_out << _get_cc_type_name();
//   _cc_out << "\nsavantConcatenate(const ";
//   if (((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_is_scalar_type() == TRUE && ((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_is_kernel_type() == FALSE){
//     ((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_publish_cc_kernel_type( _cc_out );
//   }
//   else {
//     _cc_out << ((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_get_cc_type_name();
//   }

//   _cc_out << "& lhs, const ";
//   if (((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_is_scalar_type() == TRUE && ((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_is_kernel_type() == FALSE){
//     ((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_publish_cc_kernel_type( _cc_out );
//   }
//   else {
//     _cc_out << ((IIR_ArrayTypeDefinition*)this)->get_element_subtype()->_get_cc_type_name();
//   }

//   _cc_out << "& rhs, ";
//   _cc_out << _get_cc_type_name();
//   _cc_out << "*, const ArrayTypeInfo &);\n";
// }

void
IIRScram_TypeDefinition::_publish_cc_decl_event_class(const char *) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_decl_event_class( _cc_out )");
}

// void 
// IIRScram_TypeDefinition::_publish_cc_concatenation_operator( published_file &_cc_out ) {
//   _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_concatenation_operator( _cc_out )");
// }

void
IIRScram_TypeDefinition::_publish_cc_decl_predefined_procedures_prototypes( published_file &_cc_out ){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_decl_predefined_procedures_prototypes( _cc_out )");
}

void 
IIRScram_TypeDefinition::_publish_cc_elaborate( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc_elaborate" );

  if( _is_scalar_type() == TRUE && _is_kernel_type() == FALSE ){
    _publish_cc_kernel_type( _cc_out );
  }
  else {
    _cc_out << _get_cc_type_name();
  }
}

void
IIRScram_TypeDefinition::_publish_cc_data_members( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_data_members( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_decl_constructors( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_decl_constructors( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_type_constructors( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_type_constructors( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_subtype_constructors( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_subtype_constructors( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_decl_destructors( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_decl_destructors( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_type_destructors( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_type_destructors( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_subtype_destructors( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_subtype_destructors( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_decl_operator_equalto( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_decl_operator_equalto( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_decl_operator_subscript( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_decl_operator_subscript( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_type_operator_equalto( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_type_operator_equalto( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_subtype_operator_equalto( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_subtype_operator_equalto( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_decl_cc( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_decl_cc( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_subelement_type( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_subelement_type( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_anonymous_type_name( ostream &os ){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_anonymous_type_name( ostream & )");  
}

void
IIRScram_TypeDefinition::_publish_cc_base_type_name( published_file &_cc_out ) {
  if( _is_subtype_decl() == TRUE ){
    if( _is_enumeration_type() == TRUE ){
      _cc_out << get_base_type()->_get_cc_type_name();
    }
    else {
      ASSERT(_get_type_mark() != NULL);
      _cc_out << _get_type_mark()->_get_cc_type_name();
    }
  }
  else if(get_base_type() != NULL && get_base_type()->_get_declaration() != NULL) {
    _cc_out << get_base_type()->_get_cc_type_name();
  }
  else {
    _cc_out << _get_cc_type_name();
  }
}

void
IIRScram_TypeDefinition::_publish_cc_init_signal( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_init_signal( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_composite_init( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_composite_init( _cc_out )");  
}

void
IIRScram_TypeDefinition:: _publish_cc_init_quantity(published_file &_cc_out) {
  _report_undefined_scram_fn("_publish_cc_init_quantity()");
}


ostream &
IIRScram_TypeDefinition::_print( ostream &os ){
  os << *_get_declarator();
  return os;
}

IIR_Int32
IIRScram_TypeDefinition::_get_num_indexes(){
  // This is over-ridden in IIR_ArrayTypeDefinition...
  return 0;
}

IIR_Boolean 
IIRScram_TypeDefinition::_is_anonymous(){
  if( _get_declaration() == NULL ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}

IIR_Boolean 
IIRScram_TypeDefinition::_is_element(){
  return is_element();
}

IIR_Boolean 
IIRScram_TypeDefinition::_is_resolved_type(){
  if (_get_resolution_function() != NULL) {
    return TRUE;
  }
  return FALSE;
}

IIR_Boolean 
IIRScram_TypeDefinition::is_element(){
  ASSERT( _is_access_type() == TRUE || _is_array_type() == FALSE );
  return FALSE;
}

void 
IIRScram_TypeDefinition::set_is_element( IIR_Boolean ){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::IIRScram_TypeDefinition::set_is_element");
  abort();
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::_get_type_of_element( int index ){
  // Repeated almost verbatim in IIRScram_FunctionDeclaration
  if( index > _get_num_indexes() ){
    return NULL;
  }
  
  IIR_TypeDefinition *current_subtype = (IIR_TypeDefinition *)this;
  if( index == 0 ){
    return current_subtype;
  }

  int i;
  for( i = 0; i < index - 1; i++ ){
    ASSERT( current_subtype->_is_array_type() == TRUE );

    current_subtype = current_subtype->_get_element_subtype();
  }
  
  IIR_TypeDefinition *retval = current_subtype->_get_element_subtype();
  
  return retval;
}

IIR_TypeDefinition*
IIRScram_TypeDefinition::_is_explicit_type_conversion_needed(IIR_TypeDefinition *targetType) {
  // This method checks to see if an explicit type conversion needs to be
  // code-generated. If so it returns the common type else it return NULL.

  if (targetType == this) {
    return NULL;
  }

  if (targetType->_is_anonymous() == TRUE) {
    targetType = targetType->_get_bottom_base_type();
  }
  
  if (_is_base_type(targetType)) {
    // Target type is the base type of this type. No explicit type conversion
    // is needed.
    return NULL;
  }

  // return the most compaitable type.
  return _is_compatible(targetType);
}

IIR_Boolean
IIRScram_TypeDefinition::_is_base_type(IIR_TypeDefinition *_base) {
  IIR_TypeDefinition *base_type = _get_base_type();

  while (base_type != NULL) {
    if ((base_type == _base) ||
	(IIRScram_TextLiteral::_cmp(base_type->_get_declarator(), _base->_get_declarator()) == 0)) {
      return TRUE;
    }

    base_type = base_type->_get_base_type();
  }

  return FALSE;
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::_index_constrain_array( IIR_ScalarTypeDefinition *constraint ){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_index_constrain_array( IIR_ScalarTypeDefinition *)");  
  return 0;
}

void
IIRScram_TypeDefinition::_publish_cc_decl_type_attributes( published_file &_cc_out ) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_decl_type_attributes( _cc_out )");  
}

void
IIRScram_TypeDefinition::_publish_cc_necessary_decl_in_state( published_file &_cc_out ){
  // Dummy function. 
}

void
IIRScram_TypeDefinition::_publish_cc_init_fields_for_signals( published_file &_cc_out ) {
  // Dummy function. Do not put undefined func. here.
}

void
IIRScram_TypeDefinition::_publish_cc_resolution_function_id( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc_resolution_function_id" );
  
  if( _get_resolution_function() != NULL ){
    _cc_out << OS("_savant_entity_elab::addResolutionFn(");
    _get_resolution_function()->_publish_cc_resolution_function_name( _cc_out );
    _cc_out << CS(")");
  }
  else{
    _cc_out << "-1";
  }
}

void
IIRScram_TypeDefinition::_publish_cc_set_resolution_function( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc_set_resolution_function" );

  if(_get_resolution_function() != NULL) {
    _cc_out << "switch(objType) {\n"
	    << "case ObjectBase::SIGNAL_NETINFO: {\n"
	    << "  int res_fn_id = _savant_entity_elab::addResolutionFn(";
    _get_resolution_function()->_publish_cc_resolution_function_name( _cc_out );
    _cc_out << ");\n"
	    << "  setResolutionFunctionId(res_fn_id);\n"
	    << "  break;\n"
	    << "}\n"
	    << "case ObjectBase::SIGNAL:\n";
    if(_is_array_type() == TRUE || _is_record_type() == TRUE) {
      _cc_out  << "  setCompositeResolvedSignal(true);\n";
    }
    _cc_out << "case ObjectBase::VARIABLE:\n"
	    << "  setParentCompositeType(this);\n"
	    << "  break;\n"
	    << "default:\n"
	    << "  break;\n"
	    << "}\n";
  }
}

void
IIRScram_TypeDefinition::_add_decl_into_cgen_symbol_table() {
  // Dummy function to keep _report_undefined_scram_fn quiet.
}

IIR_FunctionDeclaration * 
IIRScram_TypeDefinition::_resolve_resolution_function( IIR_Name *resolution_function ){
  IIR_FunctionDeclaration *resolution_function_decl = NULL;

  set<IIR_Declaration> *func_decls;
  func_decls = resolution_function->_symbol_lookup( &IIR::_is_iir_function_declaration );
  if( func_decls == NULL ){
    report_undefined_symbol( resolution_function );
  }

  resolution_function_decl = (IIR_FunctionDeclaration *)resolve_if_one( func_decls );

  delete func_decls;

  return resolution_function_decl;
}

IIR_ScalarTypeDefinition *
IIRScram_TypeDefinition::_determine_type_of_bound( IIR *left_or_right ){
  IIR_ScalarTypeDefinition *retval = NULL;

  ASSERT( left_or_right != NULL );
  
  set<IIR_TypeDefinition> *left_or_right_types = left_or_right->_get_rval_set();
  if( left_or_right_types == NULL ){
    report_undefined_symbol( left_or_right );
    return NULL;
  }

  left_or_right_types->reduce_set( &IIR::_is_iir_scalar_type_definition );
  
  IIR_ScalarTypeDefinition *left_or_right_type = NULL;  
  switch( left_or_right_types->num_elements() ){
  case 0:{
    ostringstream err;
    err << "|" << *left_or_right << "| is not a scalar type and isn't valid in this context.";
    report_error( left_or_right, err.str() );
    break;
  }
  
  case 1:{
    retval = (IIR_ScalarTypeDefinition *)left_or_right_types->get_element();
    ASSERT( retval->_is_scalar_type() == TRUE );
    break;
  }
    
  default:{
    if( left_or_right_types->in_set( StandardPackage::get_savant_universal_integer() ) == TRUE ){
      left_or_right_type = StandardPackage::get_savant_universal_integer();
      retval = left_or_right_type;
    }
    else if( left_or_right_types->in_set( StandardPackage::get_savant_universal_real() ) == TRUE ){
      left_or_right_type = StandardPackage::get_savant_universal_real();
      retval = left_or_right_type;
    }
    else{
      report_ambiguous_error( left_or_right, left_or_right_types );
      retval = (IIR_ScalarTypeDefinition *)left_or_right_types->get_element();
    }

    break;
  }
  }

  delete left_or_right_types;

  return retval;
}

IIR_ScalarTypeDefinition *
IIRScram_TypeDefinition::_construct_new_type( IIR_RangeTypeDefinition *temp_range,
					      IIR_TypeDeclaration *type_decl ){
  // We have a range like 1 to 10, or -2.0 to 7.1. The only other legal
  // possibility is for this to be type'range.  (This method should only be
  // used for creating a new type in a type declaration.

  IIR_ScalarTypeDefinition *retval = NULL;
  
  IIR *left = temp_range->get_left();
  ASSERT( left != NULL );

  IIR_ScalarTypeDefinition *left_type = _determine_type_of_bound( left );

  IIR *right = temp_range->get_right();
  if( right != NULL ){
    IIR_ScalarTypeDefinition *right_type = _determine_type_of_bound( right );
    if( right_type == NULL ){
      return NULL;
    }

    if( left_type->_is_iir_integer_type_definition() == TRUE ){
      if( right_type->_is_iir_integer_type_definition() == TRUE ){
	retval = IIR_IntegerTypeDefinition::_construct_new_type( temp_range, type_decl );
      }
      else{
	ostringstream err;
	err << "|" << *left << " " << *temp_range->get_direction() << " " << *right
	    << "| is not a valid range in this context. |" << *right << "| is not an "
	    << "integer type, and |" << *left << "| is.";
	report_error( temp_range, err.str() );
	retval = NULL;
      }
    }
    else if ( left_type->_is_iir_floating_type_definition() == TRUE ){
      if( right_type->_is_iir_floating_type_definition() == TRUE ){
	retval = IIR_FloatingTypeDefinition::_construct_new_type( temp_range, type_decl );	
      }
      else{
	ostringstream err;
	err << "|" << *left << " " << *temp_range->get_direction() << " " << *right
	    << "| is not a valid range in this context. |" << *right << "| is not an "
	    << "floating type, and |" << *left << "| is.";
	report_error( temp_range, err.str() );
	retval = NULL;
      }
    }
    else{
      ostringstream err;
      err << "Internal error in IIRScram_TypeDefinition::_construct_new_type - "
	  << "got a left that is a " << left_type->get_kind_text() << " and I don't know "
	  << "what to do!";
      report_error( temp_range, err.str() );
      abort();
    }
  } 
  else{
    // Then the left better have been a 'range.
    ostringstream err;
    err << "'range temporarily not supported in this context!";
    report_error( temp_range, err.str() );
    abort();
  }
  
  ASSERT( retval != NULL );
  ASSERT( retval->_is_resolved() == TRUE );
  
  return retval;
}

IIR*
IIRScram_TypeDefinition::_get_direction(){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_get_direction()");  
  return  NULL;
}

IIR_TypeDefinition*
IIRScram_TypeDefinition::_get_base_type(){
  // This is the default case.  It's overloaded in several places as well.
  return get_base_type();
}

IIR*
IIRScram_TypeDefinition::_get_base_type_left(){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_get_base_type_left()");  
  return  NULL;
}

IIR*
IIRScram_TypeDefinition::_get_base_type_direction(){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_get_base_type_direction()");  
  return  NULL;
}

IIR*
IIRScram_TypeDefinition::_get_base_type_right(){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_get_base_type_right()");  
  return  NULL;
}

IIR_TextLiteral *
IIRScram_TypeDefinition::_get_declarator(){
  if( _get_declaration() != NULL ){
    return _get_declaration()->_get_declarator();
  }
  else{
    char *string = "<ANONYMOUS>";
    return IIR_Identifier::get( string, strlen( string ) );
  }
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::_is_compatible( IIR_TypeDefinition *to_check ){
  
  ASSERT( this != NULL );

  // Check for NULL types.
  if( to_check == (IIR_TypeDefinition*)StandardPackage::get_savant_null_type_definition() ){
    return (IIR_TypeDefinition *)this;
  }
  else if( this == (IIR_TypeDefinition*)StandardPackage::get_savant_null_type_definition() ){
    return (IIR_TypeDefinition *)to_check;
  }


  IIR_TypeDefinition *base_type_left = 0;
  IIR_TypeDefinition *base_type_right = 0;
  // Check for "normal" compatibility.
  if( _is_subtype() == TRUE ){
    base_type_left = get_base_type();
  }
  else{
    base_type_left = (IIR_TypeDefinition *)this;
  }
  
  if( to_check->_is_subtype() == TRUE ){
    base_type_right = to_check->get_base_type();
  }
  else{
    base_type_right = to_check;
  }

  if( base_type_left == base_type_right ){
    if( to_check->_is_subtype() == TRUE && _is_subtype() == FALSE ){
      return to_check;
    }
    else{
      return (IIR_TypeDefinition *)this;
    }
  }

  // Check for special cases, like universal ints being compared with
  // other integer types.
  return _check_special_compatible( to_check );
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::_check_special_compatible( IIR_TypeDefinition * ){
  //  _report_undefined_scram_fn("IIRScram_TypeDefinition::_check_special_compatible( IIR_TypeDefinition * )");
  return NULL;
}

set<IIR_TypeDefinition> *
IIRScram_TypeDefinition::_get_rval_set(IIR_Boolean (IIR::*constraint_function)() ){
  return new set<IIR_TypeDefinition>( (IIR_TypeDefinition *)this );
}

void 
IIRScram_TypeDefinition::_type_check( set<IIR_TypeDefinition> * ){
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::_construct_new_subtype( IIR_Name *, IIR_ScalarTypeDefinition * ){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::IIRScram_TypeDefinition::_construct_new_subtype( IIR *resolution_function, IIR_ScalarTypeDefinition *new_constraint )");  
  return NULL;
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::_get_new_subtype( ){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::IIRScram_TypeDefinition::_get_new_subtype( )");  
  return NULL;
}

IIR_FunctionDeclaration *
IIRScram_TypeDefinition::_get_resolution_function( ){
  return NULL; 
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::_construct_new_subtype_resolution_function_only( IIR_Name *resolution_function ){
  IIR_TypeDefinition *retval;

  retval = _get_new_subtype();
  _clone( retval );

  if( resolution_function != NULL ){
    IIR_FunctionDeclaration *resolution_function_decl;
    resolution_function_decl = _resolve_resolution_function( resolution_function );

    retval->_set_resolution_function( resolution_function_decl );
  }

  if( _is_subtype() == true ){
    retval->set_base_type( get_base_type() );
  }
  else{
    retval->set_base_type( (IIR_TypeDefinition *)this );
  }

  return retval;
}

void 
IIRScram_TypeDefinition::_clone( IIR *copy_into ){
  ASSERT( copy_into->_is_iir_type_definition() == TRUE );

  IIR_TypeDefinition *as_type = (IIR_TypeDefinition *)copy_into;
  as_type->set_base_type( get_base_type() );
  as_type->_set_declaration( _get_declaration() );

  IIR::_clone( copy_into );
}

void
IIRScram_TypeDefinition::_publish_cc_temporary_type_info( published_file &_cc_out,
							  char *, 
							  char *) {
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_temporary_type_info(char *, char *)");
}

void
IIRScram_TypeDefinition::_publish_cc_type_info( published_file &_cc_out ){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_type_info( _cc_out )");
}

void
IIRScram_TypeDefinition::_publish_cc_constructor_args_type_info( published_file &_cc_out,
								 IIR *initializer ){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_constructor_args_type_info( publ_cc_out, initialization )");
}


void
IIRScram_TypeDefinition::_publish_cc_type_info_scoping_prefix( published_file &_cc_out,
							       const bool commaFlag ){
  IIR *_old_publish_node = _get_current_publish_node();
  IIR_Boolean prefix     = FALSE;
  
  if (_is_anonymous() == FALSE) {
    IIRScram_Declaration *typeDecl = _get_declaration();
    ASSERT ( typeDecl != NULL );
    ASSERT ( typeDecl->_get_declarative_region() != NULL );

    if( _get_current_publish_node() == NULL ){
      _set_current_publish_node( typeDecl->_get_declarative_region() );
    }
    
    // Determine the correct scope in which the type_info has been declared...
    if ( _get_elaboration_class() != NULL ){
      if (commaFlag == TRUE) {
	_cc_out << ", ";
      }
      
      // If we are publishing in the state of a process or a process we
      // need to add the enclosing scope pointer ourselves...
      
      if( _get_currently_publishing_unit() == PROCESS ){
	ASSERT ( _get_current_process_statement() != NULL );
	_cc_out << "((" 
		<< _get_current_process_statement()->_get_enclosing_scope()->_get_cc_elaboration_class_name()
		<< " *) getProc())->";
	prefix = TRUE;
      }
      if (_get_currently_publishing_unit() == PROCESS_STATE) {
	if (typeDecl->_get_declarative_region()->get_kind() ==
	    IIR_PROCESS_STATEMENT) {
	  // Okay...this declaration is in the process's declarative region
	  // so we don't need a scoping prefix etc...
	  _cc_out << "processPtr";
	  
	  prefix = TRUE;
	}
	else {
	  _cc_out << "(("
		  << _get_current_publish_node()->_get_cc_elaboration_class_name()
		  << " *)processPtr->getProc())->";
	  prefix = TRUE;
	}
      }
      
      if ((_get_currently_publishing_unit() == PROCEDURE) ||
	  (_get_currently_publishing_unit() == FUNCTION)) {
	if (typeDecl->_get_declarative_region()->get_kind() == IIR_PROCESS_STATEMENT) {
	  _cc_out << "((";
	  typeDecl->_get_declarative_region()->_get_declarator()->_publish_cc_lvalue( _cc_out );
	  _cc_out << " *) processPtr)->";
	  prefix = TRUE;
	}
	else {
	  // Okay.. have to publish necessary scope..
	  // The type declaration could be in any one of the enclosing scopes..
	  // like say entity declaration/ architecture declaration etc...

	  // Hack...this will work only for one level...and not more..
	  // HAVE TO FIX THIS...

	  if( typeDecl->_get_declarative_region() == _get_current_publish_node() ||
	      (_get_current_publish_node() != NULL && 
	       _get_current_publish_node()->_is_iir_concurrent_statement() == TRUE )) {
	    // Okay...
	    _cc_out << "((";
	    _get_current_publish_node()->_publish_cc_class_name( _cc_out.get_stream() );
	    _cc_out << " *) processPtr->getProc())->";
	    prefix = TRUE;
	  }
	  else {
	    cerr << "Error - IIRScram_TypeDefinition.cc::"
		 << "_publish_cc_type_info_scoping_prefix(bool) - unhandled"
		 << "case in publishing scoping prefix for object defined in "
		 << "subprogram but type is declared in outer scope.\n";
	    _cc_out << "NULL";
	    prefix = TRUE;
	  }
	}
      }
      
      if( typeDecl->_get_declarative_region() == _get_current_publish_node() ){
	if( _get_currently_publishing_unit() == TYPE ){
	  if (prefix == FALSE) {
	    _cc_out << "enclosingScope->";
	  }
	}
	else {
	  if (prefix == FALSE) {
	    _cc_out << "this->";
	  }
	}
      }
      else {
	IIR *curr_node = _get_current_publish_node();
	if( _get_currently_publishing_unit() == PROCESS &&
	    curr_node->get_kind() != IIR_PROCESS_STATEMENT &&
	    _get_current_process_statement() != NULL ){
	  curr_node = _get_current_process_statement();
	}

	ASSERT ( curr_node != NULL );
	ostringstream os;
	curr_node->_publish_cc_scoping_prefix( os,
					       typeDecl->_get_declarative_region(),
					       curr_node );
	string scopingPrefix = os.str();
	if( scopingPrefix.length() == 0 ){
	  if( prefix == FALSE ){
	    // Nothing dumped..so just print this...
	    _cc_out << "this->";
	  }
	}
	else {
	  _cc_out << scopingPrefix;
	}
      }
    }
    else {
      if (typeDecl->_get_declarative_region()->get_kind() ==
	  IIR_PROCESS_STATEMENT) {
	if (_get_currently_publishing_unit() == PROCESS_STATE) {
	  _cc_out << "processPtr->";
	}
      }
    }
  }
  _set_current_publish_node( _old_publish_node );
}

void
IIRScram_TypeDefinition::_publish_cc_object_type_info( published_file &_cc_out,
						       const IIR_Boolean commaFlag, 
						       const char *additionalSuffix,
						       const IIR_Boolean temporaryFlag ){
  SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc_object_type_info" );
  _publish_cc_include( _cc_out );
  
  IIR *_old_publish_node = _get_current_publish_node();
  
  if (_is_anonymous() == FALSE) {
    if (_get_elaboration_class() != NULL)  {
      _publish_cc_type_info_scoping_prefix( _cc_out, commaFlag );
      _publish_cc_lvalue( _cc_out );
      if (additionalSuffix != NULL) {
	_cc_out << additionalSuffix;
      }
      _cc_out << "_info";
    }
    else {
      // It could be a package declaration...
      // or the type declaration could be in a process statement.
      // If the type declaration was in a function/procedure
      //   then we don't have to publish something special..
      SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc_object_type_info" );

      ASSERT ( _get_declaration() != NULL );
      if( _get_declaration()->_get_declarative_region()->get_kind() == IIR_PROCESS_STATEMENT ){
	if (_get_currently_publishing_unit() == PROCESS) {
	  if (commaFlag == TRUE) {
	    _cc_out << "," << NL();
	  }
	  _publish_cc_lvalue( _cc_out );
	  if (additionalSuffix != NULL) {
	    _cc_out << additionalSuffix;
	  }
	  _cc_out << "_info";
	}
	if( _get_currently_publishing_unit() == PROCESS_STATE ){
	  if (commaFlag == TRUE) {
	    _cc_out << "," << NL();
	  }
	  _cc_out << "processPtr->Savant" << *_get_declarator()
		  << "Type";
	  if( additionalSuffix != NULL ){
	    _cc_out << additionalSuffix;
	  }
	  _cc_out << "_info";
	}
	
	if(( _get_currently_publishing_unit() == PROCEDURE )||
	   (_get_currently_publishing_unit() == FUNCTION)) {
	  if ( commaFlag == TRUE ){
	    _cc_out << "," << NL();
	  }
	  _cc_out << "((";
	  _get_declaration()->_get_declarative_region()->_publish_cc_class_name( _cc_out.get_stream() );
	  _cc_out << " *) processPtr)->Savant" << *_get_declarator()
		  << "Type";
	  if (additionalSuffix != NULL) {
	    _cc_out << additionalSuffix;
	  }
	  _cc_out << "_info";
	}
      }
      else {
	// Nothing to do for package declarations. Later on maybe type info
	// structure should become static memembers of the package
	if (commaFlag == TRUE) {
	  _cc_out << "," << NL();
	}
	IIR *declRegn = _get_declaration()->_get_declarative_region();
	if( !declRegn->_is_iir_package_declaration() &&
	    !declRegn->_is_iir_package_body_declaration() &&
	    !declRegn->_is_iir_subprogram_declaration() ){
	  _cc_out << "*";
	}
	_publish_cc_lvalue( _cc_out );
	if (additionalSuffix != NULL) {
	  _cc_out << additionalSuffix;
	}
	_cc_out << "_info";
      }
    }
  }
  else {
    // It's anonymous
    if (_is_kernel_type() == TRUE) {
      // Okay. If its a kernel type we can figure out what the subtype is
      // going to be from the base type!!
      ASSERT (_get_base_type() != NULL);
      if (commaFlag == TRUE) {
	_cc_out << "," << NL();
      }
      
      _cc_out << "new ";
      _get_base_type()->_publish_cc_lvalue( _cc_out );
      if (additionalSuffix != NULL) {
	_cc_out << additionalSuffix;
      }
      _cc_out << "_info";
    }
    else {
      if ((_is_array_type() == TRUE) && (temporaryFlag == TRUE)) {
	// This is an anonymous array type. Could be the 2nd dimension
	// used in aggregates etc.  In this case, we publish a temporary
	// array_type_info object.
	if (commaFlag == TRUE)  {
	  _cc_out << "," << NL();
	}
	_publish_cc_temporary_type_info( _cc_out );
      }
      else {
	if (_get_base_type() != NULL) {
	  _get_base_type()->_publish_cc_object_type_info( _cc_out,
							  commaFlag, 
							  additionalSuffix, 
							  temporaryFlag );
	}
	else {
	  // Okay. One last try. If it is a integer type, then, well use the
	  // default SavantintegerType_info. Rest of the guys we cannot do much.
	  if (_is_integer_type() == TRUE)  {
	    if (commaFlag == TRUE) {
	      _cc_out << "," << NL();
	    }
	    _cc_out << "SavantintegerType_info";
	  }
	  else {
	    if (_is_floating_type() == TRUE) {
	      if (commaFlag == TRUE) {
		_cc_out << "," << NL();
	      }
	      _cc_out << "SavantrealType_info";
	    }
	    else {
	      ostringstream err;
	      err << "Warning [IIRScram_TypeDefinition::"
		  << "_publish_cc_object_type_info( _cc_out )] :: Maybe missing "
		  << "type info for " << get_kind_text();
	      report_error( this, err.str() );
	    }
	  }
	}
      }
    }
  }
  _set_current_publish_node( _old_publish_node );
}

void
IIRScram_TypeDefinition::_publish_cc_extern_type_info( published_file &_cc_out ){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_publish_cc_extern_type_info( _cc_out )");
}

IIR*
IIRScram_TypeDefinition::_get_elaboration_class() {
  IIR_Declaration *decl = _get_declaration();

  if (decl == NULL) {
    // An anonymous type definition...well, there has to be a base type
    // somewhere that has a decl!! we need to sope there... otherwise
    // this guy has no elaboration class. Could be the 2nd dimension of a
    // 2 dimensional array or something like that...

    if (_get_base_type() != NULL) {
      return _get_base_type()->_get_elaboration_class();
    }
    
    if (_get_type_mark() != NULL) {
      return _get_type_mark()->_get_elaboration_class();
    }
    
    return NULL;
  }
  
  IIR* declRgn = decl->_get_declarative_region();
  ASSERT ( declRgn != NULL );
  
  if ((declRgn->_is_subprogram() == TRUE) ||
      (declRgn->get_kind() == IIR_PROCESS_STATEMENT) ||
      (declRgn->_is_iir_package_declaration() == TRUE) ||
      (declRgn->_is_iir_package_body_declaration() == TRUE)) {
    return NULL;
  }

  return declRgn;
}

void 
IIRScram_TypeDefinition::_publish_cc_typeInfo( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc_typeInfo" );

  if( _is_array_type() && !_is_access_type() ){
    _publish_cc_extern_type_info( _cc_out );
    if( _get_element_subtype()->_is_scalar_type() &&
	!_get_element_subtype()->_is_kernel_type()){
      _get_element_subtype()->_publish_cc_extern_type_info( _cc_out );
    }
    return;
  }
  
  if(_is_scalar_type() == TRUE &&
     _is_access_type() == FALSE){
    _cc_out << "extern ";
    switch(get_kind()){
    case IIR_INTEGER_SUBTYPE_DEFINITION:
    case IIR_INTEGER_TYPE_DEFINITION:
      _cc_out << "IntegerTypeInfo ";
      break;
    case IIR_FLOATING_SUBTYPE_DEFINITION:
    case IIR_FLOATING_TYPE_DEFINITION:
      _cc_out << "RealTypeInfo ";
      break;
    case IIR_ENUMERATION_SUBTYPE_DEFINITION:
    case IIR_ENUMERATION_TYPE_DEFINITION:
      _cc_out << "EnumerationTypeInfo ";
      break;
    case IIR_PHYSICAL_SUBTYPE_DEFINITION:
    case IIR_PHYSICAL_TYPE_DEFINITION:
      _cc_out << "PhysicalTypeInfo ";
      break;

    default:
      break;
    }
    _publish_cc_lvalue( _cc_out );
    _cc_out << "_info;" << NL();
  }
}

void 
IIRScram_TypeDefinition::_come_into_scope( symbol_table *sym_tab, 
					   IIR_TypeDeclaration *type_decl ){
  
  // Type decl should _only_ be NULL for the universal operators.
  ASSERT( type_decl != NULL || this == StandardPackage::get_savant_universal_integer() ||
	  this == StandardPackage::get_savant_universal_real() );
  
  set<IIR_Declaration> *implicit_decls = NULL;

  if( type_decl != NULL ){
    implicit_decls = type_decl->_get_implicit_declarations();
  }

  if(  implicit_decls == NULL ){
    implicit_decls = new set<IIR_Declaration>();
    _build_implicit_operators( implicit_decls );

    if( type_decl != NULL ){
      type_decl->_set_implicit_declarations( implicit_decls );
    }
  }
  
  ASSERT( implicit_decls != NULL );
  ASSERT( implicit_decls->num_elements() > 0 );
  sym_tab->add_declaration( implicit_decls );
}

void 
IIRScram_TypeDefinition::_build_implicit_operators( set<IIR_Declaration> *add_to ){
  // So, ALL types have these relational operators defined.
  char *operators[] = { "\"=\"", "\"/=\"", NULL };
  _build_implicit_operators( operators, add_to, StandardPackage::get_boolean_type(), this, this );
  if( _is_numeric_type() == TRUE ){
    char *addition_operators[] = { "\"+\"", "\"-\"", NULL };
    _build_implicit_operators( addition_operators, add_to, this, this, this );
    // This is unary +/-
    _build_implicit_operators( addition_operators, add_to, this, this );
    _build_implicit_operator( "\"abs\"", add_to, this, this );
  }
  
  if( this == StandardPackage::get_bit_type() || this == StandardPackage::get_boolean_type() ){
    _build_logical_operators( add_to );
  }
}

void 
IIRScram_TypeDefinition::_build_implicit_operator( char *op, 
						   set<IIR_Declaration> *add_to,
						   IIRScram_TypeDefinition *return_type,
						   IIRScram_TypeDefinition *left_type,
						   IIRScram_TypeDefinition *right_type ){

  IIR_FunctionDeclaration *new_operator = new IIR_FunctionDeclaration();
  new_operator->set_declarator( IIR_StringLiteral::get(op, strlen(op) ) );
  
  IIR_ConstantInterfaceDeclaration *left = new IIR_ConstantInterfaceDeclaration();
  left->set_declarator( IIR_Identifier::get("left", strlen("left")) );
  left->set_subtype( (IIR_TypeDefinition *)left_type );
  left->_set_is_visible( FALSE );
  new_operator->_set_is_implicit( TRUE );
  IIRScram::copy_location( this, left );
  new_operator->interface_declarations.append( left );
  
  if( right_type != NULL ){
    IIR_ConstantInterfaceDeclaration *right = new IIR_ConstantInterfaceDeclaration();
    right->set_declarator( IIR_Identifier::get("right", strlen("right") ) );
    right->set_subtype( (IIR_TypeDefinition *)right_type );
    right->_set_is_visible( FALSE );
    new_operator->_set_is_implicit( TRUE );
    IIRScram::copy_location( this, right );
    new_operator->interface_declarations.append( right );
  }

  new_operator->set_return_type( (IIR_TypeDefinition *)return_type );
  new_operator->_set_is_implicit( TRUE );
  IIRScram::copy_location( this, new_operator );
  
  add_to->add( new_operator );
}

void 
IIRScram_TypeDefinition::_build_implicit_operators( char *ops[], 
						    set<IIR_Declaration> *add_to,
						    IIRScram_TypeDefinition *return_type,
						    IIRScram_TypeDefinition *left_type,
						    IIRScram_TypeDefinition *right_type ){
  int i = 0;
  char *current = ops[i];
  while( current != NULL ){
    _build_implicit_operator( current, add_to, return_type, left_type, right_type );
    current = ops[++i];
  }
}

void 
IIRScram_TypeDefinition::_build_logical_operators( set<IIR_Declaration> *add_to ){
  char *logical_operators[] = {
    "\"and\"", "\"or\"", "\"nand\"", "\"nor\"", "\"xor\"", "\"xnor\"", 0
  };

  _build_implicit_operators( logical_operators, add_to, this, this, this );
  _build_implicit_operator( "\"not\"", add_to, this, this );
}

void 
IIRScram_TypeDefinition::_build_ordering_operators( set<IIR_Declaration> *add_to ){
  // Scalar types have these relational operators defined.
  char *operators[] = { "\"<\"", "\"<=\"", "\">\"", "\">=\"", NULL };

  _build_implicit_operators( operators, add_to, 
			     StandardPackage::get_boolean_type(), this, this );
}

IIR_TypeDefinition *
IIRScram_TypeDefinition::_get_designated_subtype(){
  _report_undefined_scram_fn("IIRScram_TypeDefinition::_get_designated_subtype()");
  return NULL;
}

void 
IIRScram_TypeDefinition::_publish_cc_include( published_file &_cc_out ){
  if( _get_declaration() && 
      _get_declaration()->_get_declarative_region() &&
      _get_declaration()->_get_declarative_region()->_is_iir_library_unit() ){
    _get_declaration()->_get_declarative_region()->_publish_cc_include( _cc_out );
  }
  else if ( get_base_type() ){
    ASSERT( get_base_type() != this );
    get_base_type()->_publish_cc_include( _cc_out );
  }
}

void 
IIRScram_TypeDefinition::_publish_cc_headers( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_TypeDefinition::_publish_cc_include" );
  if(_is_kernel_type() == FALSE) {
    if (_is_anonymous() == FALSE) {
      ostringstream file_name_stream;
      IIR_Boolean flag = FALSE;
      
      ASSERT ( _get_declaration() != NULL );
      ASSERT ( _get_declaration()->_get_declarative_region() != NULL );
      IIR *declRegn = _get_declaration()->_get_declarative_region();

      if( declRegn == _get_current_publish_node() ){
	return;
      }
      
      if( declRegn->_is_iir_concurrent_statement() == TRUE ||
	  declRegn->get_kind() == IIR_PROCESS_STATEMENT ){
	declRegn->_publish_cc_class_name(file_name_stream);
	flag = TRUE;
      }
      else {
	if ( declRegn->_is_iir_package_declaration() == TRUE ||
	     declRegn->_is_iir_package_body_declaration() == TRUE ){
	  if ( _get_currently_publishing_unit() != IIRScram::PACKAGE_BODY &&
	       _get_currently_publishing_unit() != IIRScram::PACKAGE_PUB ){
	    declRegn->_publish_cc_binding_name( file_name_stream );
	    flag = TRUE;
	  }
	}
      }
      
      if (flag == TRUE) {
	// Some data has been published...
	file_name_stream << ".hh";
	_publish_cc_include( _cc_out, file_name_stream.str());
      }
    }
    else {
      if (get_base_type() != NULL) {
	get_base_type()->_publish_cc_include(_cc_out);
      }
    }
  }
}

void 
IIRScram_TypeDefinition::_publish_cc_include( published_file &os, 
					      const string &to_include ){

  IIRScram::_publish_cc_include( os, to_include );
}

void
IIRScram_TypeDefinition::_publish_cc_constructor_args_type_info_composite_type( published_file &_cc_out,
										IIR *initializer ){
  _publish_cc_object_type_info( _cc_out );
  _cc_out << "," << NL();
  _publish_cc_resolution_function_id( _cc_out );
  
  if( _is_anonymous() == TRUE ){
    _cc_out << "," << NL();
    _publish_cc_range( _cc_out );
  } 
  else if( _is_unconstrained_array_type() && initializer != NULL &&
	   initializer->get_kind() != IIR_CONCATENATION_OPERATOR ){
    _cc_out << "," << NL();
    initializer->_publish_cc_range( _cc_out );
  }

  // Now, deal with the initializer
  if( initializer != 0 ){
    _cc_out << ", ";
    initializer->_publish_cc_initialization_value( _cc_out );
  }
}
