/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_CLIPBOARD__
#define __SG_CLIPBOARD__

#include "sg_worksheet.h"
#include "sg_plot.h"

void	sg_clipboard_init		(void);
void	sg_clipboard_copy		(SGworksheet *sg_sheet,
					 gboolean clear);
void	sg_clipboard_paste		(SGworksheet *sg_sheet);
void	sg_clipboard_clear		(void);
void 	sg_clipboard_copy_pixmap	(SGplot *plot);
void 	sg_clipboard_paste_pixmap	(SGplot *plot,
                          		 gdouble x, gdouble y);
					 
#endif /* __SG_CLIPBOARD__ */

