/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plot_file.h"

SGplotfile*
sg_plot_file_new (SGplot *plot, gchar *filename)
{
  SGplotfile *file;

  file = g_new(SGplotfile, 1);
  file->filename = NULL;
  if(filename) file->filename = g_strdup(filename); 
  file->plot = plot;
  file->in_project = FALSE;

  file->save_plot = NULL;
  file->save_layer = NULL;
  file->save_dataset = NULL;
  file->save_axis = NULL;

  file->set_line_style = NULL;
  file->set_symbol_style = NULL;
  file->put_text = NULL;

  return file;
}

void
sg_plot_file_export (SGplotfile *file, gboolean in_project)
{  
  file->in_project = in_project;
  file->save_plot(file);
}

void
sg_plot_file_export_data (SGplotfile *file, 
			  SGdataset *dataset, 
			  gboolean save_points)
{  
  file->save_dataset(file, dataset, save_points);
}

void
sg_plot_file_destroy (SGplotfile *file)
{  
  if(file->filename) g_free(file->filename);
  g_free(file);
}

