/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"
#include "helper.h"
#include "gtincl.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>

int file_accessible_ro (char* file) {
  int myfd;
  myfd = open(file,O_RDONLY);
  close(myfd);
  if (myfd == -1) return 0;
  else return 1;
}

int open_myFile_ro (char* file) {
  int myfd;
	
  if (str_len(file) && strcmp(file,"-")) {
    myfd=open(file,O_RDONLY);
    if (myfd==-1) {
      errexit(_("Error, could not access %s: %s\n"),file, strerror(errno));
    }
    myprintf(0,_("Accessing %s\n"),file);
  } else {
    myfd=STDIN_FILENO;
    myprintf(0,"%s\n",_("Accessing stdin"));
  }
  if (isatty(myfd)) {
    myprintf(0,"%s:\n",_("Please input the data and finish with Ctrl-D on an empty line"));
  }
  return(myfd);
}

int open_myFile_rw(char* file){
  int myfd;

  if (str_len(file) && strcmp(file,"-")) {
    myfd=open(file ,O_RDWR|O_CREAT|O_EXCL, S_IRUSR|S_IWUSR|S_IRGRP);
    if (myfd==-1){
      close(myfd);
      errexit(_("%s could not be created: %s\n"),file, strerror(errno));
    } else {
      myprintf(0,_("%s created.\n"),file);
    }
  }else{
    myfd=STDOUT_FILENO;
  }
  return(myfd);
}

void close_myFile (int filedes) {
  if (filedes > 2) {
    close(filedes);
  }
}
