/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"
#include "helper.h"
#include "config.h"
#include "gtincl.h"

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <ctype.h>

void help_print_line(const char* longoption,
		     char shortoption,
		     const char* text)
{
  const char* temp;
  char line[80+1];
  char* lp; //pointer in line;
  unsigned int longspace = 25;
  unsigned int textspace = (sizeof(line)-1)-(longspace+3)-2-2-2;

  memset(line,0,sizeof(line));
  memset(line,' ',sizeof(line)-1);
  //first line of an option
  lp = line+1;
  if (longoption != NULL) {
    strncpy(lp,"--",2);
    strncpy(lp+2,longoption,strlen(longoption));
  }
  lp += longspace+2;
  if (isalpha((int)shortoption)) {
    lp[0] = '-';
    lp[1] = shortoption;
  }
  lp += 2+2;

  do {
    if (str_len(text) <= textspace) {
      sprintf(lp,"%s",text);
      temp = NULL;
    } else {
      temp = text+textspace;
      while (!isspace((int)*temp)) --temp;
      if (temp == text) temp = text+textspace;
      snprintf(lp,temp-text+1,"%s",text);
      text = temp;
    }
    fprintf(stdout,"%s\n",line);
    //other lines
    memset(line,' ',sizeof(line)-1);
    lp = line+1+longspace+2+2+2;
  } while (temp != NULL);
}

void help(char *me){
  char* name;
  
  if ((name = rindex(me,'/')) == NULL) {
    name = me;
  } else {
    ++name;
  }
  printf(_("This is a program written by %s\n"),PACKAGE_BUGREPORT);
  printf("%s\n",_("This program is licenced with the GPL."));
  printf("%s\n",_("Use at your own risk!"));
  printf("%s\n\n",_("You need a phone made by Siemens to get an useful result."));
  printf(_("Syntax: %s [options] action [mem type] [sms options] [file...]\n"),name);

  printf("\n%s:\n",_("Options"));
  help_print_line("device <device>",'d',_("specify another than the compiled in device"));
  help_print_line("baud <baudrate>",'b',_("specify another than the compiled in baudrate"));
  help_print_line("out <file>",'o',_("specify a file when getting ('-' for stdout)"));
  help_print_line("pipe <program>",'p',_("specify a pipe to use"));
  help_print_line("pin <pin>",0,_("use this pin if one is needed"));
  help_print_line("quiet",'q',_("decreases verbosity by 1"));
  help_print_line("verbose",'v',_("increases verbosity by 1"));
  help_print_line("system-charset <charset>",0,_("use charset for input/output from/to system"));
  help_print_line("number <number>",'n',_("specify number on send"));
  help_print_line("text <text>",'t',_("specify content on send"));

  printf("\n%s:\n",_("Actions"));
  help_print_line("remove",'r',_("removes something from the phone"));
  help_print_line("send",'s',_("sends something to the phone"));
  help_print_line("get",'g',_("get something from the phone"));
  help_print_line("info",'i',_("show various information"));
  help_print_line("mem-info",0,_("show memory information"));
  help_print_line("lock-info",0,_("show lock information"));
  help_print_line("set-time",0,_("synchronize time on phone"));
  help_print_line("set-smsc",0,_("set the SMSC number (requires option -n)"));
  help_print_line("toggle-lock <lock>",0,_("changes lock status (might need option --pin)"));
  help_print_line("dial",0,_("dials a number using remote keypad control (requires option -n)"));
  help_print_line("reset",0,_("sends some special characters and exits"));
  help_print_line("help",'h',_("print this message"));
  help_print_line("version",0,_("print the version number"));

  printf("\n%s:\n",_("Memory types"));
  help_print_line("binary",'N',_("binary file transfer"));
  help_print_line("pbook",'P',_("phonebook"));
  help_print_line("sms",'S',_("short messages"));

  printf("\n%s:\n",_("Memory type options"));
  help_print_line("mem <mem>",0,_("select a memory"));
  help_print_line("slot <slot>",0,_("select a slot or slot group"));

  printf("\n%s:\n",_("SMS options"));
  help_print_line("direct",0,_("send/receive without storing in the phone"));
  help_print_line("sort",0,_("sort short message on getting(type or slot)"));

  printf("\n%s:\n",_("SMS-PDU creation options"));
  help_print_line("unicode",0,_("use UCS-2 (unicode) as charset"));
  help_print_line("srr",0,_("request a status report from the SMSC"));
  help_print_line("flash",0,_("make the sms appear directly (if supported by the receiving entity)"));

  printf("\n%s\n",_("See man page for more detailed information."));
}

void version () {
  printf("%s\n",PACKAGE_VERSION);
}
