#ifndef SCREEM_WINDOW_PRIVATE_H
#define SCREEM_WINDOW_PRIVATE_H

#include "screem-window.h"

#include "screem-page.h"
#include "screem-site.h"

#include "screem-spell.h"
#include "screem-cvs.h"

#include "egg-recent.h"

#include "screem-mdi.h"

#include "screem-ctags-model.h"
#include "screem-ctags-view.h"

#define RECENT_SITE_GROUP	"screem-sites"
#define RECENT_PAGE_GROUP	"screem-pages"

typedef struct {
	ScreemSite *site;
	ScreemWindow *window;
} SwitchSiteData;

struct ScreemWindowDetails
{	
	ScreemMDI *mdi;

	GtkWidget *box;

	GtkWidget *notebook;

	GtkWidget *tagtree;
	GtkWidget *structure;
	GtkWidget *messages;
	GtkWidget *errors;
	
	GtkWidget *online_status;

	/* the views */
	GtkWidget *preview;
	GtkWidget *editor;
	GtkWidget *link_view;
	GtkWidget *tree_view;
	GtkWidget *design;

	/* current view */
	GtkWidget *current;

	/* Screem stuff */
	ScreemSite *current_site;
	ScreemSpell *spell;
	ScreemCVS *cvs;

	/* statusbar stuff */
	gint handle;
	GtkWidget *cursorPosition;
	GtkWidget *attrtab;
	GtkWidget *overwriteMode;
	GtkWidget *mime;
	GtkTreeModel *mimetypes;
	
	gchar *name;

	/* external browser gconf notifications,
	   icon handle, path handle, ... */
	GSList *browser_notify_handles;

	EggRecentModel *recent_site_model;
	EggRecentViewUIManager *recent_site_view;
	EggRecentModel *recent_page_model;
	EggRecentViewUIManager *recent_page_view;
	
	gboolean offline;

	guint status_timeout;

	guint markset_idle;
	
	ScreemCtagsModel *ctagsmodel;
	ScreemCtagsView *ctagsview;
};

void screem_window_recent_page_cb( GtkAction *action, gpointer data );
void screem_window_recent_site_cb( GtkAction *action, gpointer data );

void screem_window_initialise_menus( ScreemWindow *window );

void screem_window_change_view( ScreemWindow *window, GtkWidget *view );

void screem_window_add_site( ScreemWindow *window, ScreemSite *site );
void screem_window_remove_site( ScreemWindow *window, ScreemSite *site );


#endif
