/*  Screem:  screem-link-view-image.c
 *
 *  The link view widget
 *
 *  Copyright (C) 2001  Matt Colyer, David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include "screem-link-view-image.h"

static void screem_link_view_image_class_init(ScreemLinkViewImageClass *klass);
static void screem_link_view_image_init( ScreemLinkViewImage *link_view_image);
static void screem_link_view_image_finalize( GObject *link_view_image );


ScreemLinkViewImage *screem_link_view_image_new( const gchar *pathname )
{
	ScreemLinkViewImage *image;
	GType type;

	type = screem_link_view_image_get_type();

	image = SCREEM_LINK_VIEW_IMAGE( g_object_new( type, NULL ) );

	image->name = g_strdup( pathname );
	image->filename = g_strdup( pathname );
	image->external = TRUE;	
	image->next = NULL;

	return image;
}

/* G Object stuff */
#define PARENT_TYPE G_TYPE_OBJECT

static gpointer parent_class;

static void screem_link_view_image_class_init(ScreemLinkViewImageClass *klass )
{
	GObjectClass *object_class;

	object_class = G_OBJECT_CLASS( klass );
	parent_class = g_type_class_peek_parent( klass );


	object_class->finalize = screem_link_view_image_finalize;
}

static void screem_link_view_image_init( ScreemLinkViewImage *link_view_image )
{

}

static void screem_link_view_image_finalize( GObject *link_view_image )
{
	ScreemLinkViewImage *image;

	image = SCREEM_LINK_VIEW_IMAGE( link_view_image );

	if( image->name ) {
		g_free( image->name );
	}
	if( image->filename ) {
		g_free( image->filename );
	}
	if( image->next ) {
		g_object_unref( image->next );
	}

	G_OBJECT_CLASS( parent_class )->finalize( G_OBJECT( image ) );
}

GType screem_link_view_image_get_type()
{
	static guint type = 0;

	if( ! type ) {
		static const GTypeInfo info = {
			sizeof( ScreemLinkViewImageClass ),
			NULL, /* base init */
			NULL, /* base finalise */
			(GClassInitFunc)screem_link_view_image_class_init,
			NULL, /* class finalise */
			NULL, /* class data */
			sizeof( ScreemLinkViewImage ),
			0, /* n_preallocs */
			(GInstanceInitFunc)screem_link_view_image_init
		};
		
		type = g_type_register_static( PARENT_TYPE,
					       "ScreemLinkViewImage",
					       &info, 0 );
	}

	return type;
}


