/*  selectwm - X11 window manager selector
 *
 *  Copyright (C) 1999-2002  Luc Dufresne - luc@ordiluc.net
 *                           26, rue des Comices
 *                           59650 Villeneuve d'Ascq
 *                           FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#include "define.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "misc.h"
#include "miscui.h"
#include "options.h"
#include "exec.h"
#include "searchwm.h"
#include "modify.h"

/* main window */

void quit_selectwm (GtkWidget *w, gpointer data) {
	config *selectwm_config = (config *) data;
	
	write_config (selectwm_config);
	gtk_main_quit ();
}

void goback_callback (GtkWidget *widget, gpointer data) {
	config *selectwm_config = (config *) data;

	gtk_timeout_remove (selectwm_config->timer);
	if (GTK_TOGGLE_BUTTON (widget)->active)
		selectwm_config->restart_selectwm = TRUE;
	else
		selectwm_config->restart_selectwm = FALSE;
}

gint timerfnc (gpointer data) {
	GString *str;
	config *selectwm_config = (config *) data;
	
	selectwm_config->elapsed_delay -= 0.1;
	if (selectwm_config->elapsed_delay <= 0.0) {
		gtk_timeout_remove (selectwm_config->timer);
		exec_wm (selectwm_config);
	}
	str = g_string_new ("");
	g_string_printf (str, "%.1f", selectwm_config->elapsed_delay);
	gtk_label_set_text (GTK_LABEL (selectwm_config->label), str->str);
	g_string_free (str, TRUE);
	return (TRUE);
}

gint list_enter (GtkWidget *widget, GdkEventKey *event, gpointer data) {
	config *selectwm_config = (config *) data;
	
	gtk_timeout_remove (selectwm_config->timer);
	switch (event->keyval) {
		case GDK_Return:
			exec_wm (selectwm_config);
			break;
		}
	return FALSE;
}

static void exec_callback (gpointer a, gpointer b) {
	exec_wm ((config *) b);
}

static void find_wm_callback (gpointer a, gpointer b) {
	find_wm ((config *) b);
}

gint list_click (GtkWidget *widget, GdkEventButton *event, gpointer data) {
	GtkWidget *menu,*menu_item;
	config *selectwm_config = (config *) data;
	
	gtk_timeout_remove (selectwm_config->timer);

	if (event->button == 1 && event->type == GDK_2BUTTON_PRESS) {
		exec_wm (selectwm_config);
		return TRUE;
	}
	
	if (event->button == 3 && event->type == GDK_BUTTON_PRESS) {
		menu = gtk_menu_new ();

		menu_item = gtk_tearoff_menu_item_new ();
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item);	

		menu_item = gtk_image_menu_item_new_with_mnemonic (_("_search for known window managers...")); 
		gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menu_item), gtk_image_new_from_stock (GTK_STOCK_FIND, GTK_ICON_SIZE_MENU));
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item);
		g_signal_connect (G_OBJECT (menu_item),"activate", G_CALLBACK (find_wm_callback), selectwm_config);

		menu_item = gtk_image_menu_item_new_with_mnemonic (_("_add item..."));
		gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menu_item), gtk_image_new_from_stock (GTK_STOCK_ADD, GTK_ICON_SIZE_MENU));
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item);
		g_signal_connect (G_OBJECT (menu_item),"activate", G_CALLBACK (add_item), selectwm_config);

		menu_item = gtk_separator_menu_item_new ();
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item);
		
		menu_item = gtk_image_menu_item_new_with_mnemonic (_("e_xecute window manager")); 
		gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menu_item), gtk_image_new_from_stock (GTK_STOCK_EXECUTE, GTK_ICON_SIZE_MENU));
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item);
		g_signal_connect (G_OBJECT (menu_item), "activate", G_CALLBACK (exec_callback), selectwm_config);

		menu_item = gtk_image_menu_item_new_with_mnemonic (_("_edit item..."));
		gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menu_item), gtk_image_new_from_stock (GTK_STOCK_PROPERTIES, GTK_ICON_SIZE_MENU));
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item);
		g_signal_connect (G_OBJECT (menu_item),"activate", G_CALLBACK (edit_item), selectwm_config);

		menu_item = gtk_menu_item_new_with_mnemonic (_("set as _default"));
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item);
		g_signal_connect (G_OBJECT (menu_item),"activate", G_CALLBACK (default_item), selectwm_config);

		menu_item = gtk_image_menu_item_new_with_mnemonic (_("_delete item"));
		gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menu_item), gtk_image_new_from_stock (GTK_STOCK_DELETE, GTK_ICON_SIZE_MENU));
		gtk_menu_shell_append (GTK_MENU_SHELL (menu), menu_item);
		g_signal_connect (G_OBJECT (menu_item),"activate", G_CALLBACK (delete_item), selectwm_config);

		gtk_widget_show_all (menu);
		gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, event->button, event->time);
		return TRUE;
	}

	return FALSE;
}

/* edit config window */

void change_options (GtkWidget *w, gpointer data) {
	ch_options *choptions = (ch_options *)data;
	
	choptions->selectwm_config->delay = gtk_spin_button_get_value (GTK_SPIN_BUTTON (choptions->spin));
	gtk_widget_destroy (choptions->window);
}

void gob1_callback (GtkWidget *widget, gpointer data) {
	config *selectwm_config =(config *)data;
	selectwm_config->goback_btn = 1;
}

void gob2_callback (GtkWidget *widget, gpointer data) {
	config *selectwm_config =(config *)data;
	selectwm_config->goback_btn = 2;
}

void gob3_callback (GtkWidget *widget, gpointer data) {
	config *selectwm_config =(config *)data;
	selectwm_config->goback_btn = 3;
}
