# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test;
BEGIN { plan tests => 1 };
use SigC;
ok(1); # If we made it this far, we're ok.

#########################

# Insert your test code below, the Test module is use()ed here so read
# its man page ( perldoc Test ) for help writing this test script.

use strict;
use warnings;
#use diagnostics;

# This function is used in derived modules' Makefile.PL files,
# check that we can find it
SigC::configure();

SigC::create_glue_code("glue_test_file", ["perlobject.map", "typemap"],
	{"Object *" => "SigC::Object",
	"Slot *" => "SigC::Slot",
	"Connection *" => "SigC::Connection",
	"SignalBase *" => "SigC::Signal"});

my $func = sub {
#print "Anonymous sub called\n";
};

#print "Created anonymous function\n";

my $slot = SigC::slot($func)
	|| die "Couldn't create slot from anonymous function\n";

#print "Created a slot to call the anonymous function\n";

$slot->call();

my $obj = {};
bless ($obj);

#print "Created blessed hash\n";

sub foo {
#print "foo called\n";
};

#print "Created named method\n";

my $slot2 = SigC::slot($obj, "foo")
	|| die "Couldn't create slot from object and method\n";

#print "Created a slot to call the method on the hash\n";

$slot2->call();

ok(1);

#print "Creating signal\n";
my $my_signal = new SigC::Signal;

#print "Connecting to signal\n";
my $conn1 = $my_signal->connect($slot);
#print "Connecting to signal again\n";
my $conn2 = $my_signal->connect($slot2);

ok(1);

$my_signal->emit();

$conn2->disconnect();

$my_signal->emit();

ok(1);

sub bar {
#print "bar called\n";
};

my $slot3 = SigC::slot($obj, "bar");

$slot3->call();

my $conn3 = $my_signal->connect($slot3);

$my_signal->emit();

ok(1);

$conn1->disconnect();

$my_signal->emit();

$conn3->disconnect();

$my_signal->emit();

ok(1);

# Check slot creation from named functions

SigC::slot("foo") || die "Couldn't create slot from named function\n";

ok(1);
