#include "Image.h"

@interface NSImage (flags)
- (void) setArchiveByName: (BOOL) flag;
@end

@implementation NSImage (flags)
- (void) setArchiveByName: (BOOL) flag
{
	_flags.archiveByName = flag;
}
- (void) setNameForced: (NSString*) aName
{
	ASSIGN(_name,aName);
}
@end

@implementation Image

Class theNSImageClass;

+ (id) imageNamed: (NSString *)aName
{
	BOOL providedInTheme = YES;
    	NSBundle* bundle = [NSBundle bundleForClass: NSClassFromString(@"SimpleUI")];
	NSImage* ret = nil;

	if ([aName isEqualToString: @"NSSwitch"]
		|| [aName isEqualToString: @"common_SwitchOff"])
	{
		NSImage* image = [[NSImage alloc] initWithSize: NSMakeSize (16,16)];
		[image lockFocus];
		[GSDrawFunctions drawButton: NSMakeRect (0,0,16,16) inView: nil highlighted: NO];
		[image unlockFocus];
		ret = image;
	}
	else if ([aName isEqualToString: @"NSHighlightedSwitch"]
		|| [aName isEqualToString: @"common_SwitchOn"])
	{
		NSImage* image = [[NSImage alloc] initWithSize: NSMakeSize (16,16)];
		[image lockFocus];
		[GSDrawFunctions drawButton: NSMakeRect (0,0,16,16) inView: nil highlighted: NO];
		NSImage* checkmark = [NSImage imageNamed: @"common_2DCheckMark.tiff"]; 
		[checkmark compositeToPoint: NSMakePoint (4,4) operation: NSCompositeSourceOver];
		[image unlockFocus];
		ret = [image autorelease];
	}
	else if ([aName isEqualToString: @"NSRadioButton"]
		|| [aName isEqualToString: @"common_RadioOff"])
	{
		NSImage* image = [[NSImage alloc] initWithSize: NSMakeSize (16,16)];
		[image lockFocus];
		[GSDrawFunctions drawRadioButton: NSMakeRect (0,0,16,16) inView: nil highlighted: NO];
		[image unlockFocus];
		ret = image;
	}
	else if ([aName isEqualToString: @"NSHighlightedRadioButton"]
		|| [aName isEqualToString: @"common_RadioOn"])
	{
		NSImage* image = [[NSImage alloc] initWithSize: NSMakeSize (16,16)];
		[image lockFocus];
		[GSDrawFunctions drawRadioButton: NSMakeRect (0,0,16,16) inView: nil highlighted: YES];
		[image unlockFocus];
		ret = [image autorelease];
	}
	else if (
		   [aName isEqualToString: @"common_TabSelectedLeft.tiff"]
		|| [aName isEqualToString: @"common_TabSelectedRight.tiff"]
		|| [aName isEqualToString: @"common_TabSelectedToUnSelectedJunction.tiff"]
		|| [aName isEqualToString: @"common_TabUnSelectToSelectedJunction.tiff"]
		|| [aName isEqualToString: @"common_TabUnSelectedJunction.tiff"]
		|| [aName isEqualToString: @"common_TabUnSelectedLeft.tiff"]
		|| [aName isEqualToString: @"common_TabUnSelectedRight.tiff"]
		)
	{
		NSImage* image = [[NSImage alloc] initWithSize: NSMakeSize (14,17)];
		[image lockFocus];
		if (
		   [aName isEqualToString: @"common_TabSelectedLeft.tiff"]
		|| [aName isEqualToString: @"common_TabUnSelectedLeft.tiff"]
		|| [aName isEqualToString: @"common_TabSelectedToUnSelectedJunction.tiff"]
		|| [aName isEqualToString: @"common_TabUnSelectedJunction.tiff"]
		)
		{
			NSBezierPath* path = [NSBezierPath bezierPath];
			[path moveToPoint: NSMakePoint (0,0)];
			[path curveToPoint: NSMakePoint (14,17) 
			     controlPoint1: NSMakePoint (8, 2) 
			     controlPoint2: NSMakePoint (8, 14)];
			NSBezierPath* background = [NSBezierPath bezierPath];
			[background appendBezierPath: path];
			[background lineToPoint: NSMakePoint (14, 0)];
			[background closePath];
			[[NSColor windowBackgroundColor] set];
			[background fill];
			//[[NSColor blackColor] set];
			[[NSColor colorWithCalibratedRed: 0.3 green: 0.3 blue: 0.4 alpha: 0.8] set];
			[path setLineWidth: 1.5];
			[[NSColor controlLightHighlightColor] set];
			[path stroke];
		}
		if (
		   [aName isEqualToString: @"common_TabSelectedRight.tiff"]
		|| [aName isEqualToString: @"common_TabUnSelectedRight.tiff"]
		|| [aName isEqualToString: @"common_TabSelectedToUnSelectedJunction.tiff"]
		|| [aName isEqualToString: @"common_TabUnSelectedJunction.tiff"]
		|| [aName isEqualToString: @"common_TabUnSelectToSelectedJunction.tiff"]
		)
		{	
			NSBezierPath* path = [[NSBezierPath alloc] init];
			[path moveToPoint: NSMakePoint (0,17)];
			[path curveToPoint: NSMakePoint (14,0) 
			     controlPoint1: NSMakePoint (8, 14) 
			     controlPoint2: NSMakePoint (8, 2)];
			NSBezierPath* background = [NSBezierPath bezierPath];
			[background appendBezierPath: path];
			[background lineToPoint: NSMakePoint (0, 0)];
			[background closePath];
			[[NSColor windowBackgroundColor] set];
			[background fill];
			//[[NSColor blackColor] set];
			[[NSColor colorWithCalibratedRed: 0.3 green: 0.3 blue: 0.4 alpha: 0.8] set];
			[[NSColor controlShadowColor] set];
			[path setLineWidth: 1.5];
			[path stroke];
		}
		if ( [aName isEqualToString: @"common_TabUnSelectToSelectedJunction.tiff"] )
		{
			NSBezierPath* path = [NSBezierPath bezierPath];
			[path moveToPoint: NSMakePoint (0,0)];
			[path curveToPoint: NSMakePoint (14,17) 
			     controlPoint1: NSMakePoint (8, 2) 
			     controlPoint2: NSMakePoint (8, 14)];
			NSBezierPath* background = [NSBezierPath bezierPath];
			[background appendBezierPath: path];
			[background lineToPoint: NSMakePoint (14, 0)];
			[background closePath];
			[[NSColor windowBackgroundColor] set];
			[background fill];
			[[NSColor whiteColor] set];
			//[[NSColor blackColor] set];
			[[NSColor colorWithCalibratedRed: 0.3 green: 0.3 blue: 0.4 alpha: 0.8] set];
			[path setLineWidth: 1.5];
			[[NSColor whiteColor] set];
			[[NSColor controlLightHighlightColor] set];
			[path stroke];
		}
		[image unlockFocus];
		ret = [image autorelease];
	}
	else
	{
		providedInTheme = NO;
	}

	if (providedInTheme == NO)
	{
	//	NSLog (@"SimpleUI theme could'nt provide %@", aName);
	//	ret = [[NSImage alloc] initWithContentsOfFile: [bundle pathForImageResource: aName]];
		if (ret == nil) 
		{
			ret = [super imageNamed: aName];
		}
	}
	else
	{
		if (ret != nil)
		{
			if(![ret setName: aName])
			{
				[ret setNameForced: aName];
			}
			[ret setArchiveByName: YES];
		}
	}
	return ret;
}

+ (void) setNSImageClass: (Class) aClass
{
	theNSImageClass = aClass;
}

- (Class) classForCoder
{
	return [theNSImageClass class];
}

@end
