/*
 * KAKASI (Kanji Kana Simple inversion program)
 * $Header: kakasi.h,v 2.0 92/07/18 12:07:12 takahasi Exp $
 * Copyright (C) 1992
 * Hironobu Takahashi (takahasi@tiny.or.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either versions 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with KAKASI, see the file COPYING.  If not, write to the Free
 * Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* $Log:	kakasi.h,v $
 * Revision 2.0  92/07/18  12:07:12  takahasi
 * *** empty log message ***
 * 
*/
typedef struct character {
    char type;
    unsigned char c1, c2;
} Character;

/* character set */
#define ASCII    0
#define JISROMAN 1
#define GRAPHIC  2
#define KATAKANA 3
#define JIS78    4
#define JIS83    5
#define OTHER  127

/* assign */
#define SETG0  0
#define SETG1  1
#define SETG2  2
#define SETG3  3
#define SJKANA 4

/* terminal type */
#define UNKNOWN 0
#define OLDJIS  1
#define NEWJIS  2
#define DEC     3
#define EUC     4
#define MSKANJI 5

extern int input_term_type;

extern int input_GL;
extern int input_GR;
extern int input_G[5];

extern int output_term_type;

extern int output_GL;
extern int output_GR;
extern int output_G[5];

extern int        a2j(),        a2E();
extern int j2a(),               j2E();
extern int g2a(), g2j(),        g2E();
extern int k2a(), k2j(),               k2H(), k2K();
extern int E2a(), E2j();
extern int H2a(), H2j(), H2k(),               H2K();
extern int K2a(), K2j(), K2k(),        K2H();
extern int J2a(), J2j(), J2k(),        J2H(), J2K();

/* Other prototypes */

extern void getkanji();
extern void putkanji();
extern void ungetkanji();
extern int term_type_str();
extern void set_input_term();
extern void set_output_term();

extern void exc78_83();

extern void mkitaijitbl();
extern void itaijiknj();

extern void init_jisyo();
extern void add_jisyo();
extern void init_kanwa();
extern void add_kanwa();

extern int H2rom();
extern int K2rom();

/* options */

#define HEPBURN 0
#define KUNREI  1

extern int romaji_type;
extern int romaji_capitalize;
extern int romaji_upcase;
extern int bunkatu_mode;
extern int heiki_mode;
extern int furigana_mode;
extern int cr_eat_mode;
extern int separator_out;

int *max_hindo;
