/*
    This file is part of the sly ident daemon (slidentd).  slidentd 
    was written by Sean Hunter <sean@uncarved.com> as a minimal 
    RFC1413 (ident) daemon.

    slidentd is copyright (c) 2001 Uncarved Systems Ltd.

    slidentd is free software; you can redistribute it and/or modify
    it under the terms of version 2 of the GNU General Public License 
    as published by the Free Software Foundation.

    slidentd is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    in the file COPYING along with slidentd; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "slid_die.h"
#include "slid_log.h"
#include <str.h>
#include <stralloc.h>
#include <buffer.h>
#include <unistd.h>

#define SLID_PREALLOC_ERROR_BUFFLEN 64

static const char client_msg[] = "0, 0: ERROR: UNKNOWN-ERROR\n";

/* send an error to the client and exit */
void
slid_dies()
{
	buffer *log_buffer = slid_get_log_buffer();
	buffer_flush(log_buffer);
	buffer_putsflush(buffer_1, client_msg);
	close(STDOUT_FILENO);
	_exit(-1);
}

/* send an error to the client, log a message and exit */
void
slid_die(const char *err)
{
	buffer *log_buffer = slid_get_log_buffer();
	stralloc *remote_ip = slid_get_remote_ip();

	slid_put_datestamp(log_buffer);
	buffer_puts(log_buffer, "A [");
	buffer_puts(log_buffer, remote_ip->s);
	buffer_puts(log_buffer, "] ERROR - ");
	buffer_puts(log_buffer, err);
	buffer_putsflush(log_buffer, "\n");
	slid_dies();
}
