/***************************************************************************
    smb4kbookmark.h  - A bookmark container.
                             -------------------
    begin                : Feb 04 2004
    copyright            : (C) 2004 by Franck Babin
    email                : babinfranck@yahoo.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SMB4KBOOKMARK_H
#define SMB4KBOOKMARK_H

// Qt includes
#include <qstring.h>

/**
 * This class is a container for a setted bookmark on a samba share
 */
class Smb4KBookmark
{
  public:
    /**
     * The constructor.
     *
     * @param share   The share name. It has to look like this: //HOST/SHARE.
     *
     * @param type    The type of the share, i.e. "disk" or "printer".
     */
    Smb4KBookmark( const QString &share, const QString &type );
    /**
     * The empty constructor.
     */
    Smb4KBookmark() {}
    /**
     * The destructor.
     */
    ~Smb4KBookmark();
    /**
     * This function returns the share name.
     */
    QString getShare() const;
    /**
     * This function returns the type of the share.
     */
    QString getType() const;
    
  private:
    /**
     * The share name.
     */
    QString m_share;
    /**
     * The type of the share;
     */
    QString m_type;
};

inline bool operator<( const Smb4KBookmark &b1, const Smb4KBookmark &b2 )
{
  return qstrcmp( b1.getShare().ascii() , b2.getShare().ascii() ) < 0;
}

#endif
