/***************************************************************************
                          smb4kshare  -  description
                             -------------------
    begin                : Do Mr 4 2004
    copyright            : (C) 2004 by Franck Babin
    email                : babinfranck@yahoo.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qdir.h>

// system includes
#include <unistd.h>
#include <sys/types.h>
  
// application specific includes
#include "smb4kshare.h"

 
Smb4KShare::Smb4KShare( const QString &name, const QString &path, const QString &filesystem, const int uid, const int gid, bool broken ) : m_name(name), m_path(path), m_filesystem( filesystem ), m_userinfo( uid, gid ), m_cifs_login( QString::null ), m_broken( broken )
{
  //FIXME should throw an exception if one of the param is empty
  
  if ( uid != (int)getuid() && gid != (int)getgid() )
  {
    m_foreign_mount = true;
  }
  else
  {
    m_foreign_mount = false;
  }
}


Smb4KShare::Smb4KShare( const QString &name, const QString &path, const QString &filesystem, const QString &username, bool foreign, bool broken ) : m_name(name), m_path(path), m_filesystem( filesystem ), m_userinfo( 0, 0 ), m_cifs_login( username ), m_foreign_mount( foreign ), m_broken( broken )
{
}


Smb4KShare::Smb4KShare( const Smb4KShare &s ) : m_name( s.getName() ), m_path( s.getPath() ), m_filesystem( s.getFilesystem() ), m_userinfo( s.getUID(), s.getGID() ), m_cifs_login( s.getCIFSLogin() ), m_foreign_mount( s.isForeign() ), m_broken( s.isBroken() )
{
}


Smb4KShare::~Smb4KShare(){}



QString Smb4KShare::getName() const
{
  return m_name;
}


QString Smb4KShare::getPath() const
{
  return m_path;
}


QString Smb4KShare::getCanonicalPath() const
{
  return m_broken ? m_path : QDir( m_path ).canonicalPath();
}


int Smb4KShare::getUID() const
{
  return m_userinfo.uid();
}


int Smb4KShare::getGID() const
{
  return m_userinfo.gid();
}


QString Smb4KShare::getUser() const
{
  return m_userinfo.user();
}


QString Smb4KShare::getGroup() const
{
  return m_userinfo.group();
}


QString Smb4KShare::getFilesystem() const
{
  return m_filesystem;
}


QString Smb4KShare::getCIFSLogin() const
{
  return m_cifs_login;
}


bool Smb4KShare::isForeign() const
{
  return m_foreign_mount;
}


bool Smb4KShare::isBroken() const
{
  return m_broken;
}


void Smb4KShare::setBroken( bool broken )
{
  m_broken = broken;
}


