/***************************************************************************
    main.cpp  -  Main file of the Smb4K program.
                             -------------------
    begin                : Sam Mr  1 14:57:21 CET 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kiconloader.h>
#include <dcopclient.h>

#include "smb4k.h"

Smb4KCore *app_core = 0L;

static const char *description = 
I18N_NOOP( "Smb4K is an SMB/CIFS share browser for KDE.\nIt uses Samba to access the local network neighborhood." );
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
  
  
static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};


void modifyConfig()
{
  if ( kapp->config()->getConfigState() != KConfig::NoAccess && kapp->config()->getConfigState() != KConfig::ReadOnly )
  {
    // Enter code to modify the config file here.
    
    // The following code can be removed in versions > 0.5.0
    
    kapp->config()->setGroup( "General Options" );
    kapp->config()->deleteEntry( "Horizontal Splitter Sizes" );
    kapp->config()->deleteEntry( "Vertical Splitter Sizes" );
    kapp->config()->deleteEntry( "Main Window Geometry" );

    kapp->config()->setGroup( "System" );
    kapp->config()->deleteEntry( "Name" );
    kapp->config()->deleteEntry( "Version" );
    kapp->config()->deleteEntry( "UID" );
    kapp->config()->deleteEntry( "GID" );
    kapp->config()->deleteEntry( "UMASK" );
    kapp->config()->deleteEntry( "Samba" );
  
    kapp->config()->setGroup( "Mount Options" );
    kapp->config()->deleteEntry( "Clean Up" );
    
    if ( kapp->config()->hasKey( "Allow Unmount Foreign" ) )
    {
      kapp->config()->writeEntry( "Unmount Foreign", kapp->config()->readBoolEntry( "Allow Unmount Foreign", false ) );
      kapp->config()->deleteEntry( "Allow Unmount Foreign" );
    }
  
    if ( kapp->config()->hasKey( "Use SU Privileges" ) )
    {
      kapp->config()->writeEntry( "Run SUID", kapp->config()->readBoolEntry( "Use SU Privileges", false ) );
      kapp->config()->writeEntry( "SUID Program", "super" );
      kapp->config()->deleteEntry( "Use SU Privileges" );
    }
  
    kapp->config()->deleteEntry( "Super" );
    
    QString suid_program;
    bool force_umount, run_suid;
    
    if ( kapp->config()->hasKey( "SUID Program" ) )
    {
      suid_program = kapp->config()->readEntry( "SUID Program" );
      kapp->config()->deleteEntry( "SUID Program" );
    }
    
    if ( kapp->config()->hasKey( "Force Unmount" ) )
    {
      force_umount = kapp->config()->readBoolEntry( "Force Unmount" );
      kapp->config()->deleteEntry( "Force Unmount" );      
    }
    
    if ( kapp->config()->hasKey( "Run SUID" ) )
    {
      run_suid = kapp->config()->readBoolEntry( "Run SUID" );
      kapp->config()->deleteEntry( "Run SUID" );
    }

    if ( !suid_program.isEmpty() )    
    {
      kapp->config()->setGroup( "Super User Privileges" );
      kapp->config()->writeEntry( "Force Unmount", force_umount );
      kapp->config()->writeEntry( "Run SUID", run_suid );
      kapp->config()->writeEntry( "SUID Program", suid_program );
    }
    
    kapp->config()->setGroup( "Browse Options" );
    if ( kapp->config()->hasKey( "Host Needs Auth" ) )
    {
      kapp->config()->writeEntry( "Auth For Browse List", kapp->config()->readBoolEntry( "Host Needs Auth", false ) );
      kapp->config()->deleteEntry( "Host Needs Auth" );
    }
    
    kapp->config()->deleteEntry( "WINS Server" );
    kapp->config()->deleteEntry( "WINS Support" );
    
    kapp->config()->deleteGroup( "Printing", true, false );
    
    kapp->config()->sync();
  }
};



int main(int argc, char *argv[])
{
  KAboutData aboutData( "smb4k", I18N_NOOP( "Smb4K" ),
  VERSION, description, KAboutData::License_GPL,
  I18N_NOOP( "(c) 2003, Alexander Reinholdt\n(c) 2004-2005, Alexander Reinholdt, Franck Babin" ), 0, "http://smb4k.berlios.de", "smb4k_bugs@web.de" );

  // Authors:
  aboutData.addAuthor( "Alexander Reinholdt", I18N_NOOP( "Developer" ), "dustpuppy@users.berlios.de" );
  aboutData.addAuthor( "Franck Babin", I18N_NOOP( "Developer" ), "babinfranck@yahoo.ca" );
  aboutData.addAuthor( "Matthew P. Barnson", I18N_NOOP( "Documentation" ), "mbarnson@users.berlios.de" );
  
  // All our credits:
  aboutData.addCredit( "Leopold Palomo Avellaneda", I18N_NOOP( "Catalan translation" ), "lepalom@wol.es" );
  aboutData.addCredit( "Radoslaw Zawartko", I18N_NOOP( "Polish translation" ), "radzaw@lnet.szn.pl" );
  aboutData.addCredit( "Nick Chen", I18N_NOOP( "Chinese Simplified translation" ), "nick_chen75@hotmail.com" );
  aboutData.addCredit( "Stanislav Yudin", I18N_NOOP( "Russian translation" ), "decvar@mail.berlios.de" );
  aboutData.addCredit( "Marc Hansen", I18N_NOOP( "Swedish translation and intensive testing" ), "marc.hansen@gmx.de" );
  aboutData.addCredit( "Giovanni Degani", I18N_NOOP( "Brazilian Portuguese translation" ), "tiefox@terra.com.br" );
  aboutData.addCredit( "Ivan Petrouchtchak", I18N_NOOP( "Ukrainian translation" ), "iip@telus.net" );
  aboutData.addCredit( "Karoly Barcza", I18N_NOOP( "Hungarian translation" ), "vector@vstart.hu" );
  aboutData.addCredit( "Quique", I18N_NOOP( "Spanish translation" ), "quique@sindominio.net" );
  aboutData.addCredit( "Michal Šulek", I18N_NOOP( "Slovak translation" ), "reloadshot@atlas.sk" );
  aboutData.addCredit( "Nicolas Ternisien", I18N_NOOP( "French translation" ), "nicolast@libertysurf.fr" );
  aboutData.addCredit( "Toyohiro Asukai", I18N_NOOP( "Japanese translation" ), "toyohiro@ksmplus.com" );
  aboutData.addCredit( "Atanas Mavrov", I18N_NOOP( "Bulgarian translation" ), "bugar@developer.bg" );
  aboutData.addCredit( "Isidoro Russo", I18N_NOOP( "Italian translation" ), "risidoro@aliceposta.it" );
  aboutData.addCredit( "Nils Kristian Tomren", I18N_NOOP( "Norwegian translations" ), "project@nilsk.net" );
  aboutData.addCredit( "Alois Nešpor", I18N_NOOP( "Czech translation" ), "alois.nespor@seznam.cz" );
  aboutData.addCredit( "Martín Carr", I18N_NOOP( "Spanish translation" ), "tincarr@gmail.com" );
  aboutData.addCredit( "Görkem Çetin", I18N_NOOP( "Turkish translation" ), "gorkem@gorkemcetin.com" );
  aboutData.addCredit( "Rashid N. Achilov", I18N_NOOP( "Testing of Smb4K under FreeBSD" ), "shelton@sentry.granch.ru" ); 
   
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KUniqueApplication app;

// This is for debugging only:    
//  KApplication app;  
 
  // Modify the configuration in case some entries changed:
  modifyConfig();
  
  app_core = new Smb4KCore( 0, "Core" );    
  Smb4KApp *smb4k = new Smb4KApp( 0, "MainApp" );
  
  app.setMainWidget( smb4k );
  
  bool startDocked;
  
  KConfigGroup config(KGlobal::config(), "Settings");
  startDocked = config.readBoolEntry("StartDocked", false);  
  
  if ( !startDocked )
    smb4k->show();

  return app.exec();
}
