/***************************************************************************
    smb4kauthoptions  -  description
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KAUTHOPTIONS_H
#define SMB4KAUTHOPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qtabwidget.h>
#include <qlabel.h>
#include <qcheckbox.h>

// KDE includes
#include <klistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kpopupmenu.h>


class Smb4KAuthOptions : public QTabWidget
{
  friend class Smb4KOptionsDlg;
  
  Q_OBJECT
  public:
    /**
     * The constructor.
     */
    Smb4KAuthOptions( QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KAuthOptions();

    void clear();

  public slots:
    void slotAddClicked();
    
  protected slots:
    void slotClearClicked();
    void slotRemoveClicked();
    void slotContextMenu( QListViewItem *item, const QPoint &point, int col );
    void slotEditClicked();
    void slotShareStateChanged( int state );
    void slotAuthDataStateChanged( int state );

  private:
    /** Enumeration for the popup menu. */
    enum MenuItem{ Edit, Remove };
    /** The Add button. */
    KPushButton *m_add;
    /** The clear button. */
    KPushButton *m_clear;
    /** The popup menu. */
    KPopupMenu *m_menu;
    int m_col;
    bool m_edit;
    QCheckBox *m_oneShare;
    /** Enabled the default authentication. */
    QCheckBox *m_defaultAuth;
    /** Default login. */
    KLineEdit *m_defaultLogin;
    /** Default password. */
    KLineEdit *m_defaultPasswd;
    /** The container for m_defaultLogin and m_defaultPasswd. */
    QWidget *m_authWidget;
    /** List view for the authentiaction data. */
    KListView *m_loginData;
    KLineEdit *m_workgroupEdit;
    KLineEdit *m_hostEdit;    
    KLineEdit *m_loginEdit;
    KLineEdit *m_passwdEdit;
    KLineEdit *m_shareEdit;

};

#endif
