/***************************************************************************
    smb4kbookmarkmenuwidget.cpp  - A bookmark popup menu.
                             -------------------
    begin                : Feb 04 2004
    copyright            : (C) 2004 by Franck Babin
                           (C) 2004 by Alexander Reinholdt
    email                : babinfranck@yahoo.ca
                           dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qvaluelist.h>
#include <qstringlist.h>
#include <qdir.h>

// KDE includes
#include <kpopupmenu.h>
#include <kapplication.h>

// application specific includes
#include "smb4kbookmarkmenuwidget.h"
#include "../core/smb4kshare.h"
#include "../smb4k.h"

/**
 * The bookmark menu widget.
 */
 
Smb4KBookmarkMenuWidget::Smb4KBookmarkMenuWidget( int display_mode, QObject *parent, const char *name )
: KActionMenu( parent, name ), m_display_mode( display_mode )
{  
  initActions();
  insertBookmarks();
  connect( sapp->core()->mounter(),         SIGNAL( importedShares() ),   this, SLOT( slotUpdatedShareList() ) );
  connect( this->popupMenu(),               SIGNAL( activated( int ) ),   this, SLOT( slotActivated( int ) ) );
  connect( sapp->core()->bookmarkHandler(), SIGNAL( bookmarksUpdated() ), this, SLOT( slotBookmarksUpdated() ) );
}


Smb4KBookmarkMenuWidget::~Smb4KBookmarkMenuWidget()
{
}


void Smb4KBookmarkMenuWidget::initActions()
{
  if ( m_display_mode == Normal )
  {
    this->insert( sapp->actionCollection()->action( "bookmarks_add_bookmark" ) );
    this->insert( sapp->actionCollection()->action( "bookmarks_edit_bookmarks" ) );
    this->popupMenu()->insertSeparator();
  }
  else if ( m_display_mode == Tray )
  {
    this->insert( sapp->actionCollection()->action( "bookmarks_edit_bookmarks" ), 0 );
    this->popupMenu()->insertSeparator( 1 );
  }
}


void Smb4KBookmarkMenuWidget::insertBookmarks()
{
  QValueList<Smb4KBookmark *> bookmarks = sapp->core()->bookmarkHandler()->getBookmarks();
  QStringList shareNames;
  
  // Due to sorting problems, we have to do this:
  for ( QValueListIterator<Smb4KBookmark *> it = bookmarks.begin(); it != bookmarks.end(); ++it )
  {
    shareNames.append( (*it)->getShare() );  
  }
  
  shareNames.sort();
  
  KActionPtrList list = sapp->actionCollection()->actions( "Bookmarks" );
  
  if ( list.count() == 0 )
  {
    for ( QStringList::ConstIterator it = shareNames.begin(); it != shareNames.end(); ++it )
    {
      KAction *a = new KAction( *it, "folder_green", 0, 0, 0, sapp->actionCollection(), *it );
      a->setGroup( "Bookmarks" );
      this->insert( a );
    }
  }
  else
  {
    for ( QStringList::ConstIterator it = shareNames.begin(); it != shareNames.end(); ++it )
    {
      bool insert = true;
      
      for ( KActionPtrList::ConstIterator i = list.begin(); i != list.end(); ++i )
      {
        if ( *it == (*i)->text() )
        {
          insert = false;
        }
      }
      
      if ( insert )
      {
        KAction *a = new KAction( *it, "folder_green", 0, 0, 0, sapp->actionCollection(), *it );
        a->setGroup( "Bookmarks" );
      }  
    }
    
    for ( KActionPtrList::ConstIterator it = list.begin(); it != list.end(); ++it )
    {
      if ( shareNames.find( (*it)->text() ) == shareNames.end() )
      {
        sapp->actionCollection()->remove( *it );
      }
    }
    
    list = sapp->actionCollection()->actions( "Bookmarks" );
    
    uint stop = m_display_mode == Normal ? 3 : 2;
    
    while ( popupMenu()->count() > stop )
    {
      popupMenu()->removeItemAt( stop );
    }
    
    for ( QStringList::ConstIterator it = shareNames.begin(); it != shareNames.end(); ++it )
    {
      for ( KActionPtrList::ConstIterator i = list.begin(); i != list.end(); ++i )
      {
        if ( (*i)->text() == *it )
        {
          this->insert( *i );
          break;
        }
      }
    }
  }
  
  if ( bookmarks.count() != 0 )
  {
    sapp->actionCollection()->action( "bookmarks_edit_bookmarks" )->setEnabled( true );
  }
  else
  {
    sapp->actionCollection()->action( "bookmarks_edit_bookmarks" )->setEnabled( false );
  }
}
 

/////////////////////////////////////////////////////////////////////////////
//  SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KBookmarkMenuWidget::slotUpdatedShareList()
{
  kapp->config()->setGroup( "Mount Options" );
  QString mount_prefix = kapp->config()->readPathEntry( "Default Directory", QString::null );
  
  KActionPtrList list = sapp->actionCollection()->actions( "Bookmarks" );
  QValueList<Smb4KShare *> shares = sapp->core()->mounter()->getShares();
  bool enable = true;
  
  for ( KActionPtrList::Iterator it = list.begin(); it != list.end(); ++it )
  {
    enable = true;
    for ( QValueListIterator<Smb4KShare *> i = shares.begin(); i != shares.end(); ++i )
    {
      if ( (*it)->text().upper() == (*i)->getName().upper() && 
            ( ((int)getuid() == (*i)->getUID() && (int)getgid() == (*i)->getGID())
            || (*i)->getCanonicalPath().startsWith( QDir::home().canonicalPath() ) 
            || (*i)->getCanonicalPath().startsWith( QDir( mount_prefix ).canonicalPath() )) )
      {
        enable = false;
        break;
      }
    }
    
    (*it)->setEnabled( enable );
  }
}


void Smb4KBookmarkMenuWidget::slotActivated( int id )
{
  QString bookmark = this->popupMenu()->text(id).stripWhiteSpace();
  
  if ( bookmark.startsWith( "//" ) )
  {
    QString host = bookmark.section( "/", 2, 2 );
    QString share = bookmark.section( "/", 3, 3 );

    sapp->core()->mounter()->mountShare( QString::null, host, QString::null, share );
  }
}


void Smb4KBookmarkMenuWidget::slotBookmarksUpdated()
{
  insertBookmarks();
}

#include "smb4kbookmarkmenuwidget.moc"
