/*
 * PlayListDVProvider.h -- DV Pump and Sundry Common Implementations
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KINO_DV_PLAY_LIST_DV_PROVIDER_H
#define _KINO_DV_PLAY_LIST_DV_PROVIDER_H

#include <string>
using std::string;

#include <playlist.h>
#include "DVPumpProvider.h"

class Frame;

typedef enum 
{
	terminate_on_end,
	loop_on_end,
	pause_on_end
}
end_of_playlist;

/** This implementation provides a threaded/read ahead access to a playlist. 
 	This alleviates IO bottlenecks associated to disk access.
*/

class PlayListDVProvider : 
	public DVPumpProvider,
	public PlayList
{
	private:
		double speed;
		double index;
		pthread_mutex_t mutex;
		end_of_playlist action;
	public:
		PlayListDVProvider( );
		PlayListDVProvider( PlayList &playlist );
		virtual ~PlayListDVProvider( );
		virtual string LogId( ) { return "PlayListDVProvider"; }
		void SetPlayList( PlayList &_playlist );
		void SetSpeed( double );
		void SetPosition( double );
		void SetSpeedAndPosition( double, double );
		double GetSpeed( ) const;
		void SetEndAction( end_of_playlist );
		void ChangeScene( int index, int scene, bool relative = true );
	private:
		bool ReadFrame( Frame & );
};

#endif

