#ident %W% %E% %Q%
###########################################################################
#include		$(MAKE_M_ARCH).def
SRCROOT=	..
RULESDIR=	RULES
include		$(SRCROOT)/$(RULESDIR)/rules.top
###########################################################################

INSDIR=		bin
TARGET=		star_fat
#SYMLINKS=	ustar tar
SYMLINKS=	star ustar tar gnutar suntar scpio spax
CPPOPTS +=	-D__STAR__
CPPOPTS +=	-DSET_CTIME -DFIFO -DUSE_MMAP -DUSE_REMOTE -DUSE_RCMD_RSH
#CPPOPTS +=	-DSET_CTIME -DFIFO -DUSE_MMAP
#CPPOPTS +=	-DSET_CTIME -DUSE_MMAP
#CPPOPTS +=	-DFIFO -DUSE_MMAP
CPPOPTS +=	-DUSE_LARGEFILES
CPPOPTS +=	-DUSE_ACL
CPPOPTS +=	-DUSE_XATTR
CPPOPTS +=	-DUSE_FFLAGS
CPPOPTS +=	-DCOPY_LINKS_DELAYED
CPPOPTS +=	-DSTAR_FAT
CFILES=		star_fat.c header.c cpiohdr.c xheader.c xattr.c \
		list.c extract.c create.c append.c diff.c restore.c \
		remove.c star_unix.c acl_unix.c fflags.c \
		buffer.c dirtime.c lhash.c \
		hole.c longnames.c names.c \
		movearch.c table.c props.c \
		fetchdir.c \
		unicode.c \
		subst.c volhdr.c \
		chdir.c match.c mem.c defaults.c dumpdate.c \
		fifo.c device.c checkerr.c
HFILES=		star.h starsubs.h dirtime.h xtab.h xutimes.h \
		movearch.h table.h props.h fifo.h diff.h restore.h \
		checkerr.h dumpdate.h bitstring.h
#LIBS=		-lunos
#LIBS=		-lschily -lc /usr/local/lib/gcc-gnulib
LIBS=		-ldeflt -lrmt -lschily $(LIB_ACL) $(LIB_ATTR) $(LIB_SOCKET)
XMK_FILE=	Makefile.man starformatman.mk

star_fat.c: star.c
	$(RM) $(RM_FORCE) $@; cp star.c $@

###########################################################################
include		$(SRCROOT)/$(RULESDIR)/rules.cmd
###########################################################################
count:	$(CFILES) $(HFILES)
	count $r1

IFDEF=	-UEVALVERS
XRELFILES=	Makefile Makefile.man star.1 star.4 star.dfl

###########################################################################
include		$(SRCROOT)/$(RULESDIR)/rules.rel
###########################################################################

rel:
	$(MAKE) -f cpio.mk $@
	$(MAKE) -f gnutar.mk $@
	$(MAKE) -f pax.mk $@
	$(MAKE) -f suntar.mk $@
	$(MAKE) -f tartest.mk $@
