/* [styx_lim.c] Scanner table for 'styx'  */

#include "scn_io.h"

#include "scn_imp.h"

/* scanner group 'styx' */

static long styxStaEdg[90] =
/* first edge per state */
{
          0,        34,        35,        36,        39,        41,
         42,        61,        74,       101,       115,       116,
        119,       124,       131,       132,       158,       163,
        168,       171,       174,       177,       192,       193,
        221,       224,       231,       238,       241,       244,
        249,       252,       255,       258,       259,       272,
        285,       311,       318,       325,       343,       346,
        347,       350,       353,       356,       359,       362,
        380,       398,       401,       404,       407,       410,
        428,       446,       453,       456,       463,       466,
        484,       497,       510,       513,       526,       529,
        542,       551,       558,       577,       580,       590,
        601,       617,       621,       628,       633,       649,
        657,       670,       681,       690,       696,       702,
        711,       717,       723,       724,       730,       736
};

static short styxStaFin[89] =
/* finite token per state */
{
    0,   2,   3,   2,   4,   1,   9,   0,   9,   0,
    5,   8,   6,   7,  11,   0,   0,   0,   0,   0,
   15,  15,  10,  15,   7,   0,   0,   0,   0,   0,
    0,   0,   0,  15,   0,  15,   0,   0,   0,   0,
    0,  16,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,  16,   0,  14,   0,
    0,  14,   0,   0,   0,  12,   0,   0,   0,   0,
   14,   0,   0,  13,   0,   0,  14,   0,   0
};

static wc_char styxEdgeC[736] =
/* lowest character per edge */
{ /*State*/
  /*   0 */        255,        128,        127,        126,        125,        124,
                   123,         97,         96,         94,         93,         92,
                    91,         65,         60,         59,         58,         48,
                    42,         40,         39,         36,         35,         34,
                    33,         32,         27,         26,         14,         13,
                    12,         11,         10,          0,
  /*   1 */          0,
  /*   2 */          0,
  /*   3 */         11,         10,          0,
  /*   4 */        256,          0,
  /*   5 */          0,
  /*   6 */        255,        128,        127,        126,        125,        124,
                    96,         94,         65,         60,         59,         58,
                    48,         42,         39,         35,         34,         33,
                     0,
  /*   7 */        255,        128,        127,         97,         96,         93,
                    92,         40,         39,         35,         34,         32,
                     0,
  /*   8 */        255,        128,        127,        126,        125,        124,
                   118,        117,        110,        109,        106,        105,
                   102,        101,         96,         94,         65,         60,
                    59,         58,         48,         42,         39,         35,
                    34,         33,          0,
  /*   9 */        256,        255,        128,        127,         97,         96,
                    93,         92,         40,         39,         35,         34,
                    32,          0,
  /*  10 */          0,
  /*  11 */         58,         48,          0,
  /*  12 */        255,        128,        127,         32,          0,
  /*  13 */        123,         97,         91,         65,         58,         48,
                     0,
  /*  14 */          0,
  /*  15 */        123,        121,        120,        117,        116,        115,
                   114,        113,        112,        111,        110,         97,
                    96,         93,         92,         91,         89,         88,
                    65,         58,         48,         40,         39,         35,
                    34,          0,
  /*  16 */        111,        110,        109,        108,          0,
  /*  17 */        111,        110,        103,        102,          0,
  /*  18 */         98,         97,          0,
  /*  19 */        111,        110,          0,
  /*  20 */         46,         45,          0,
  /*  21 */        255,        128,        127,         97,         96,         93,
                    92,         46,         45,         40,         39,         35,
                    34,         32,          0,
  /*  22 */          0,
  /*  23 */        123,        121,        120,        117,        116,        115,
                   114,        113,        112,        111,        110,         97,
                    96,         93,         92,         91,         89,         88,
                    65,         58,         48,         46,         45,         40,
                    39,         35,         34,          0,
  /*  24 */         58,         48,          0,
  /*  25 */        123,         97,         91,         65,         58,         48,
                     0,
  /*  26 */        123,         97,         91,         65,         58,         48,
                     0,
  /*  27 */        116,        115,          0,
  /*  28 */        101,        100,          0,
  /*  29 */        111,        110,        101,        100,          0,
  /*  30 */        100,         99,          0,
  /*  31 */        100,         99,          0,
  /*  32 */        101,        100,          0,
  /*  33 */          0,
  /*  34 */        255,        128,        127,         97,         96,         93,
                    92,         40,         39,         35,         34,         32,
                     0,
  /*  35 */        255,        128,        127,         97,         96,         93,
                    92,         40,         39,         35,         34,         32,
                     0,
  /*  36 */        123,        121,        120,        117,        116,        115,
                   114,        113,        112,        111,        110,         97,
                    96,         93,         92,         91,         89,         88,
                    65,         58,         48,         40,         39,         35,
                    34,          0,
  /*  37 */        123,         97,         91,         65,         58,         48,
                     0,
  /*  38 */        123,         97,         91,         65,         58,         48,
                     0,
  /*  39 */        255,        128,        127,        123,         97,         96,
                    93,         92,         91,         65,         58,         48,
                    40,         39,         35,         34,         32,          0,
  /*  40 */        102,        101,          0,
  /*  41 */          0,
  /*  42 */        102,        101,          0,
  /*  43 */        101,        100,          0,
  /*  44 */        109,        108,          0,
  /*  45 */        115,        114,          0,
  /*  46 */        102,        101,          0,
  /*  47 */        255,        128,        127,        123,         97,         96,
                    93,         92,         91,         65,         58,         48,
                    40,         39,         35,         34,         32,          0,
  /*  48 */        255,        128,        127,        123,         97,         96,
                    93,         92,         91,         65,         58,         48,
                    40,         39,         35,         34,         32,          0,
  /*  49 */        103,        102,          0,
  /*  50 */        118,        117,          0,
  /*  51 */        112,        111,          0,
  /*  52 */        103,        102,          0,
  /*  53 */        255,        128,        127,        123,         97,         96,
                    93,         92,         91,         65,         58,         48,
                    40,         39,         35,         34,         32,          0,
  /*  54 */        255,        128,        127,        123,         97,         96,
                    93,         92,         91,         65,         58,         48,
                    40,         39,         35,         34,         32,          0,
  /*  55 */         33,         32,         14,         12,         11,         10,
                     0,
  /*  56 */        101,        100,          0,
  /*  57 */         33,         32,         14,         12,         11,         10,
                     0,
  /*  58 */        106,        105,          0,
  /*  59 */        255,        128,        127,        123,         97,         96,
                    93,         92,         91,         65,         58,         48,
                    40,         39,         35,         34,         32,          0,
  /*  60 */        255,        128,        127,         97,         96,         93,
                    92,         40,         39,         35,         34,         32,
                     0,
  /*  61 */        123,         97,         96,         95,         91,         65,
                    33,         32,         14,         12,         11,         10,
                     0,
  /*  62 */        102,        101,          0,
  /*  63 */        123,         97,         96,         95,         91,         65,
                    33,         32,         14,         12,         11,         10,
                     0,
  /*  64 */        111,        110,          0,
  /*  65 */        255,        128,        127,         97,         96,         93,
                    92,         40,         39,         35,         34,         32,
                     0,
  /*  66 */        123,         97,         96,         95,         91,         65,
                    58,         48,          0,
  /*  67 */         33,         32,         14,         12,         11,         10,
                     0,
  /*  68 */        123,         97,         96,         95,         91,         65,
                    62,         61,         58,         48,         41,         40,
                    33,         32,         14,         12,         11,         10,
                     0,
  /*  69 */        102,        101,          0,
  /*  70 */        255,        128,        127,         33,         32,         14,
                    12,         11,         10,          0,
  /*  71 */         62,         61,         41,         40,         33,         32,
                    14,         12,         11,         10,          0,
  /*  72 */        255,        128,        127,         62,         61,         45,
                    44,         42,         41,         33,         32,         14,
                    12,         11,         10,          0,
  /*  73 */        256,         36,         35,          0,
  /*  74 */         33,         32,         14,         12,         11,         10,
                     0,
  /*  75 */        255,        128,        127,         33,          0,
  /*  76 */        255,        128,        127,         62,         61,         45,
                    44,         42,         41,         33,         32,         14,
                    12,         11,         10,          0,
  /*  77 */        256,        110,        109,        102,        101,         36,
                    35,          0,
  /*  78 */        123,         97,         96,         95,         91,         65,
                    33,         32,         14,         12,         11,         10,
                     0,
  /*  79 */         45,         44,         42,         41,         33,         32,
                    14,         12,         11,         10,          0,
  /*  80 */         62,         61,         33,         32,         14,         12,
                    11,         10,          0,
  /*  81 */        256,        111,        110,         36,         35,          0,
  /*  82 */        256,         98,         97,         36,         35,          0,
  /*  83 */        123,         97,         96,         95,         91,         65,
                    58,         48,          0,
  /*  84 */        256,        101,        100,         36,         35,          0,
  /*  85 */        256,        100,         99,         36,         35,          0,
  /*  86 */          0,
  /*  87 */        256,        115,        114,         36,         35,          0,
  /*  88 */        256,        112,        111,         36,         35,          0
};

static long styxEdgeS[736] =
/* follow (state+1) per edge */
{ /*State*/
  /*   0 */         0,         7,         0,         7,        11,         7,
                   11,        14,         0,         7,        11,         0,
                   11,        14,         7,        13,         7,        12,
                    7,        11,        10,         7,         9,         8,
                    7,         6,         0,         5,         0,         4,
                    3,         0,         2,         0,
  /*   1 */         0,
  /*   2 */         0,
  /*   3 */         0,         2,         0,
  /*   4 */         0,         5,
  /*   5 */         0,
  /*   6 */         0,         7,         0,         7,         0,         7,
                    0,         7,         0,         7,         0,         7,
                    0,         7,         0,         7,         0,         7,
                    0,
  /*   7 */         0,         8,         0,         8,         0,         8,
                   16,         8,         0,         8,        15,         8,
                    0,
  /*   8 */         0,         7,         0,         7,         0,         7,
                    0,        20,         0,        19,         0,        18,
                    0,        17,         0,         7,         0,         7,
                    0,         7,         0,         7,         0,         7,
                    0,         7,         0,
  /*   9 */         0,        21,        22,        21,        22,        21,
                   22,        24,        22,        23,        22,        21,
                   22,        21,
  /*  10 */         0,
  /*  11 */         0,        12,         0,
  /*  12 */         0,        13,         0,        13,         0,
  /*  13 */         0,        14,         0,        14,         0,        25,
                    0,
  /*  14 */         0,
  /*  15 */         0,        26,        27,        26,         8,        26,
                    8,        26,         8,        26,         8,        26,
                    8,         0,         8,         0,        26,        27,
                   26,         0,        26,         0,         8,         0,
                    8,         0,
  /*  16 */         0,        29,         0,        28,         0,
  /*  17 */         0,        31,         0,        30,         0,
  /*  18 */         0,        32,         0,
  /*  19 */         0,        33,         0,
  /*  20 */         0,        34,         0,
  /*  21 */         0,        35,         0,        35,         0,        35,
                   37,        35,        36,        35,        23,        35,
                    0,        35,         0,
  /*  22 */         0,
  /*  23 */         0,        38,        39,        38,        35,        38,
                   35,        38,        35,        38,        35,        38,
                   35,         0,        35,         0,        38,        39,
                   38,         0,        38,         0,        34,         0,
                   35,         0,        35,         0,
  /*  24 */         0,        25,         0,
  /*  25 */         0,         8,         0,         8,         0,         8,
                    0,
  /*  26 */         0,        40,         0,        40,         0,        40,
                    0,
  /*  27 */         0,        41,         0,
  /*  28 */         0,        42,         0,
  /*  29 */         0,        44,         0,        43,         0,
  /*  30 */         0,        45,         0,
  /*  31 */         0,        46,         0,
  /*  32 */         0,        47,         0,
  /*  33 */         0,
  /*  34 */         0,        35,         0,        35,         0,        35,
                   37,        35,        23,        35,         0,        35,
                    0,
  /*  35 */         0,        35,         0,        35,         0,        35,
                   37,        35,        23,        35,         0,        35,
                    0,
  /*  36 */         0,        38,        39,        38,        35,        38,
                   35,        38,        35,        38,        35,        38,
                   35,         0,        35,         0,        38,        39,
                   38,         0,        38,         0,        35,         0,
                   35,         0,
  /*  37 */         0,        35,         0,        35,         0,        35,
                    0,
  /*  38 */         0,        48,         0,        48,         0,        48,
                    0,
  /*  39 */         0,         8,         0,         8,        49,         0,
                    8,        16,         8,        49,         8,        49,
                    8,         0,         8,        15,         8,         0,
  /*  40 */         0,        42,         0,
  /*  41 */         0,
  /*  42 */         0,        50,         0,
  /*  43 */         0,        43,         0,
  /*  44 */         0,        51,         0,
  /*  45 */         0,        52,         0,
  /*  46 */         0,        53,         0,
  /*  47 */         0,        35,         0,        35,        54,         0,
                   35,        37,        35,        54,        35,        54,
                   35,        23,        35,         0,        35,         0,
  /*  48 */         0,         8,         0,         8,        55,         0,
                    8,        16,         8,        55,         8,        55,
                    8,         0,         8,        15,         8,         0,
  /*  49 */         0,        56,         0,
  /*  50 */         0,        57,         0,
  /*  51 */         0,        58,         0,
  /*  52 */         0,        59,         0,
  /*  53 */         0,        35,         0,        35,        60,         0,
                   35,        37,        35,        60,        35,        60,
                   35,        23,        35,         0,        35,         0,
  /*  54 */         0,         8,         0,         8,        61,         0,
                    8,        16,         8,        61,         8,        61,
                    8,         0,         8,        15,         8,         0,
  /*  55 */         0,        62,         0,        62,         0,        62,
                    0,
  /*  56 */         0,        63,         0,
  /*  57 */         0,        64,         0,        64,         0,        64,
                    0,
  /*  58 */         0,        65,         0,
  /*  59 */         0,        35,         0,        35,        66,         0,
                   35,        37,        35,        66,        35,        66,
                   35,        23,        35,         0,        35,         0,
  /*  60 */         0,         8,         0,         8,         0,         8,
                   16,         8,         0,         8,        15,         8,
                    0,
  /*  61 */         0,        67,         0,        67,         0,        67,
                    0,        62,         0,        62,         0,        62,
                    0,
  /*  62 */         0,        68,         0,
  /*  63 */         0,        69,         0,        69,         0,        69,
                    0,        64,         0,        64,         0,        64,
                    0,
  /*  64 */         0,        70,         0,
  /*  65 */         0,        35,         0,        35,         0,        35,
                   37,        35,        23,        35,         0,        35,
                    0,
  /*  66 */         0,        67,         0,        67,         0,        67,
                    0,        67,         0,
  /*  67 */         0,        71,         0,        71,         0,        71,
                    0,
  /*  68 */         0,        69,         0,        69,         0,        69,
                    0,        74,         0,        69,         0,        73,
                    0,        72,         0,        72,         0,        72,
                    0,
  /*  69 */         0,        75,         0,
  /*  70 */         0,        76,         0,        76,        71,         0,
                   71,         0,        71,         0,
  /*  71 */         0,        74,         0,        73,         0,        72,
                    0,        72,         0,        72,         0,
  /*  72 */         0,        77,         0,        77,         0,        77,
                    0,        77,         0,        77,        73,         0,
                   73,         0,        73,         0,
  /*  73 */         0,        74,        78,        74,
  /*  74 */         0,        79,         0,        79,         0,        79,
                    0,
  /*  75 */         0,        76,         0,        76,         0,
  /*  76 */         0,        77,         0,        77,         0,        77,
                   73,        77,        81,        77,        80,         0,
                   80,         0,        80,         0,
  /*  77 */         0,        74,        83,        74,        82,        74,
                   78,        74,
  /*  78 */         0,        84,         0,        84,         0,        84,
                    0,        79,         0,        79,         0,        79,
                    0,
  /*  79 */         0,        73,         0,        81,         0,        80,
                    0,        80,         0,        80,         0,
  /*  80 */         0,        74,         0,        81,         0,        81,
                    0,        81,         0,
  /*  81 */         0,        74,        85,        74,        78,        74,
  /*  82 */         0,        74,        86,        74,        78,        74,
  /*  83 */         0,        84,         0,        84,         0,        84,
                    0,        84,         0,
  /*  84 */         0,        74,        87,        74,        78,        74,
  /*  85 */         0,        74,        88,        74,        78,        74,
  /*  86 */         0,
  /*  87 */         0,        74,        89,        74,        78,        74,
  /*  88 */         0,        74,         0,        74,        78,        74
};

static string styxTokens[17] =
/* token -> string */
{
  "[other]",
  "Space",
  "Line",
  "Page",
  "Etx",
  "Parenthesis",
  "Comment",
  "Ide",
  "Nat",
  "Opr",
  "Set",
  "Seq",
  "MacInc",
  "MacDel",
  "MacDfn",
  "MacSep",
  "MacCond"
};

static byte styxFlags[17] =
/* token -> newid */
{
  0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static ConcreteImp(scn_t) styxScanner =
/* the scanner structure */
{
  "styx", /* Name    */
  89,     /* States  */
  17,     /* Tokens  */
  styxStaEdg,
  styxStaFin,
  styxEdgeC,
  styxEdgeS,
  styxTokens,
  styxFlags,
   0,     /* Groups  */
  (scn_t*)NULL,
  (short*)NULL,
  0, /* Dyck */
  (short*)NULL,
  (scn_t*)NULL
};


void Scn_get_styx(Scn_T *scn)
/* simulates a Scn_get */
{
  *scn = Scn_copy(Scn_ADT(&styxScanner));
}
