/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [pgm_base.h]      Common function library for the (test) programms       */
/*                                                                          */
/* Copyright (c) 2002 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef pgm_base_INCL
#define pgm_base_INCL


#include "standard.h"
#include "symbols.h"
#include "hmap.h"
#include "scn_pre.h"
#include "scn_base.h"
#include "prs.h"
#include "prs_io.h"
#include "ptm.h"
#include "ptm_gen.h"


#ifdef __cplusplus
extern "C" {
#endif


void PGM_init(int argc, char* argv[], void (*ctxinit)(int argc, char* argv[]))
/* init program */
;

void PGM_quit(void);                   /* quit program                      */

void PGM_initPreprocessing(c_string prepar, c_string premac, c_string cset)
/* init STYX-like macro preprocessing
   according commandline parameters 'prepar', 'premac' and 'cset'
*/
;

void PGM_quitPreprocessing(c_string prepar)
/* quit STYX-like macro preprocessing; release resources */
;

Scn_Stream PGM_initScanStream
           (
             Scn_T Scn, c_string filename,
             c_string prepar, c_string prefun,
             c_bool binmode, c_string cset,
             c_string skipset, c_bool stdTokIDs
           )
/* create and init scan stream according commandline parameters
   'filename', 'prepar', 'prefun', 'binmode' and 'cset'
   stdTokIDs --> set default token IDs
*/
;

void PGM_quitScanStream(Scn_Stream cStream)
/* close and release scan stream */
;

void PGM_initTables
     (
       c_string Environ, c_string language, PLR_Tab* PTab, Scn_T* Scn
     )
/* create scan and parse tables according commandline parameter
   'Environ' and 'language'
*/
;

PT_Cfg PGM_initParsing(Scn_Stream cStream, PLR_Tab PTab)
/* init parse term configuration for
   scan stream 'cStream' and parse table 'PTab'
*/
;

void PGM_quitTables(PLR_Tab PTab, Scn_T Scn)
/* release scan and parse tables */
;

PT_Term PGM_parse
        (
          PT_Cfg PCfg, c_string start,
          c_string shiftfun, c_string reducefun,
          c_bool early, c_bool xaron
        )
/* parse according commandline parameters
   'start', 'shiftfun', 'reducefun', 'early' and 'xaron'
*/
;

void PGM_printTree(PT_Term PTree, c_string cset, c_bool wprint)
/* print 'PTree' according commandline parameters 'cset' and 'wprint' */
;

void PGM_scan(Scn_Stream cStream, c_bool output, c_string cset, c_bool wprint)
/* scan 'cStream'
   output --> print according commandline parameters 'cset' and 'wprint'
*/
;



#ifdef __cplusplus
}
#endif

#endif
