/* ------------------------------------------------------------------------- */
/*                                                                           */
/* [styx_gen.h]                 STYX Compiler Library                        */
/*                   - realizes an abstract syntax tree -                    */
/*                                                                           */
/* Copyright (c) 2002 by D\olle, Manns.                                      */
/* ------------------------------------------------------------------------- */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef styx_gen_INCL
#define styx_gen_INCL


#include "standard.h"
#include "scn_base.h"
#include "prs.h"
#include "hmap.h"


#ifdef __cplusplus
extern "C" {
#endif


/*  
   The module [styx_gen] provides an reentrant interface for the compilation of
   STYX definitions.
*/

/* -------------------------- Types and macros ------------------------------ */

AbstractType( StyxApp_T ) /* Abstract STYX application type */
;

AbstractType( Styx_T ) /* Abstract STYX compiler type */
;

/* ----------------------------- Init & Quit --------------------------------- */

StyxApp_T STYX_app_init(void);         /* init STYX application             */

void STYX_app_quit(StyxApp_T styapp)
/* quit STYX application; release resources */
;

Styx_T STYX_init
       (
         StyxApp_T styapp, c_string language,
         void (*prMsg)(c_string msg), c_bool verbose, c_bool diagnose
       )
/* init STYX compilation for 'language';
   'prMsg'    --> print function or NULL
   'verbose'  --> (de)activate progress information
   'diagnose' --> (de)activate diagnose information
*/
;

void STYX_quit(Styx_T styctx);  /* quit STYX compilation; release resources */

/* ----------------------------- Set & Get ----------------------------------- */

void STYX_set_verbose(Styx_T styctx, c_bool verbose)
/* (de)activate progress information */
;

void STYX_set_diagnose(Styx_T styctx, c_bool diagnose)
/* (de)activate diagnose information */
;

void STYX_set_shortform(Styx_T styctx, c_bool shortform)
/* (de)activate short filenames ( default: longform ) */
;

void STYX_set_context(Styx_T styctx, Any_T extctx)
/* set external context information */
;

Any_T STYX_get_context(Styx_T styctx); /* get external context information  */

void STYX_set_fun_epath
     (
       Styx_T styctx,
       c_string (*ef_path)(Styx_T styctx, c_string language, c_string incpath)
     )
/* (re)set embedded language path retrieval function */
;

void STYX_set_fun_edfn
     (
       Styx_T styctx,
       c_string (*ef_dfn)(Styx_T styctx, c_string language, c_string incpath)
     )
/* (re)set embedded language definition retrieval function */
;

MAP(symbol,Styx_T) STYX_get_embed(Styx_T styctx)
/* STYX compilations of embedded languages or NULL;
   The result map has to be released.
*/
;

void STYX_get_tables(Styx_T styctx, PLR_Tab* PTab, Scn_T* Scn)
/* get scan & parse table */
;


/* ----------------------------- Compilation --------------------------------- */

int STYX_compile_file(Styx_T styctx, c_string stydfn, c_string incpath)
/* compiles STYX definition in file 'stydfn' and
   creates the corresponding scan & parse table;
   uses 'incpath' as include path
   RC >  0: number of syntax and semantic errors
   RC = -1: table creation failed
   RC =  0: successful compilation
*/
;

int STYX_compile_string(Styx_T styctx, c_string stydfn, c_string incpath)
/* compiles STYX definition in string 'stydfn' and
   creates the corresponding scan & parse table;
   uses 'incpath' as include path
   RC >  0: number of syntax and semantic errors
   RC = -1: table creation failed
   RC =  0: successful compilation
*/
;


/* ----------------------- Table image & source generation ------------------- */

void STYX_createTabIMG(Styx_T styctx, c_string Environ)
/* unloads scan & parse table to images
   [$'Environ'/]<Language>.lim
   [$'Environ'/]<Language>.pim (optional)
*/
;

void STYX_appendTabIMG(Styx_T styctx, BinImg_T lim, BinImg_T pim)
/* unloads scan & parse table to images 'lim' and
   optional 'pim'
*/
;

void STYX_createTabC(Styx_T styctx, c_string Environ)
/* creates scan & parse table sources
   [$'Environ'/]<Language>_lim.c
   [$'Environ'/]<Language>_pim.c (optional)
*/
;

void STYX_exportTab(Styx_T styctx, c_string Environ)
/* exports scan table definition
   [$'Environ'/]<Language>.ltbl
   [$'Environ'/]<Language>.ptbl (optional)
*/
;

void STYX_appendTabC
     (
       Styx_T styctx,
       FILE* lfp, c_string lfid, FILE* pfp, c_string pfid
     )
/* appends scan & parse table sources to files 'lfp' and
   optional 'pfp';
   'lfid', 'pfid' --> optional file names
*/
;


/* --------------------- Abstract interface generation ----------------------- */

void STYX_createABS(Styx_T styctx, c_string Environ)
/* create abstract interface [$'Environ'/]<Language>.abs */
;

void STYX_appendABS(Styx_T styctx, FILE* fp, c_string fid)
/* append abstract interface to file 'fp';
   'fid' --> optional file name
*/
;


/* --------------------- C interface generation ------------------------------ */

void STYX_createIntC(Styx_T styctx, c_string Environ)
/* create C interface [$'Environ'/]<Language>_int.c */
;

void STYX_createAntC(Styx_T styctx, c_string Environ)
/* create special abstract C interface [$'Environ'/]<Language>_ant.c */
;

void STYX_appendIntC(Styx_T styctx, FILE* fp, c_string fid)
/* append C interface to file 'fp';
   'fid' --> optional file name
*/
;

void STYX_appendAntC(Styx_T styctx, FILE* fp, c_string fid)
/* append C interface to file 'fp';
   'fid' --> optional file name
*/
;



#ifdef __cplusplus
}
#endif

#endif
