/*
 * SwamiMidi.h - Swami MIDI object header file
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SWAMI_MIDI_H__
#define __SWAMI_MIDI_H__

#include <glib.h>
#include <instpatch.h>

#include "swamidll.h"
#include "GObjSup.h"

typedef struct _SwamiMidi SwamiMidi;
typedef struct _SwamiMidiClass SwamiMidiClass;

#define SWAMI_TYPE_MIDI   (swami_midi_get_type ())
#define SWAMI_MIDI(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWAMI_TYPE_MIDI, SwamiMidi))
#define SWAMI_MIDI_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), SWAMI_TYPE_MIDI, SwamiMidiClass))
#define SWAMI_IS_MIDI(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWAMI_TYPE_MIDI))
#define SWAMI_IS_MIDI_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), SWAMI_TYPE_MIDI))

/* some standard defined for General MIDI custom controllers */
#define SWAMI_MIDI_CC_MODULATION	1
#define SWAMI_MIDI_CC_VOLUME		7
#define SWAMI_MIDI_CC_PAN		10
#define SWAMI_MIDI_CC_EXPRESSION	11
#define SWAMI_MIDI_CC_SUSTAIN		64
#define SWAMI_MIDI_CC_REVERB		91
#define SWAMI_MIDI_CC_CHORUS		93

/* MIDI event type */
typedef enum
{
  SWAMI_MIDI_NONE,		/* NULL event */
  SWAMI_MIDI_NOTE_ON,		/* note on event */
  SWAMI_MIDI_NOTE_OFF,		/* note off event */
  SWAMI_MIDI_PITCH_WHEEL,	/* pitch wheel event */
  SWAMI_MIDI_SET_CONTROL,	/* MIDI controller event */
  SWAMI_MIDI_BEND_RANGE,	/* bend range for pitch wheel in semitones */
  SWAMI_MIDI_BANK_SELECT,	/* bank select event */
  SWAMI_MIDI_PRESET_SELECT	/* preset number select event */
} SwamiMidiEvent;

/* Swami MIDI object */
struct _SwamiMidi
{
  GObject object;		/* derived from GObject */

  /*< private >*/

  gboolean active;		/* driver is active? */
};

/* Swami MIDI class */
struct _SwamiMidiClass
{
  GObjectClass parent_class;

  /*< public >*/

  int (*init_driver) (SwamiMidi *midi); /* initialize driver */
  void (*close_driver) (SwamiMidi *midi); /* close driver */
  int (*send_event) (SwamiMidi *midi, SwamiMidiEvent event, int chan,
		     int param1, int param2); /* MIDI event function */
};


SWAMI_API GType swami_midi_get_type (void);
SWAMI_API SwamiMidi *swami_midi_new (void);

SWAMI_API int swami_midi_init_driver (SwamiMidi *midi);
SWAMI_API void swami_midi_close_driver (SwamiMidi *midi);

SWAMI_API void swami_midi_send_event (SwamiMidi *midi, SwamiMidiEvent event,
				      int chan, int param1, int param2);

SWAMI_API void swami_midi_note_on (SwamiMidi *midi, int chan,
				   int note, int vel);
SWAMI_API void swami_midi_note_off (SwamiMidi *midi, int chan,
				    int note, int vel);

SWAMI_API void swami_midi_set_bank (SwamiMidi *midi, int chan, int bank);
SWAMI_API void swami_midi_set_preset (SwamiMidi *midi, int chan, int preset);

SWAMI_API void swami_midi_set_bend_range (SwamiMidi *midi, int chan,
					  int range);
SWAMI_API void swami_midi_set_pitch_wheel (SwamiMidi *midi, int chan, int val);

#endif
