/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal.graph;

import java.util.Random;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.VirtualNode;

class RankSorter {
    Random flipflop = new Random(3L);
    Node node;
    double rankSize;
    double prevRankSize;
    double nextRankSize;
    int currentRow;
    Rank rank;
    double progress;
    DirectedGraph g;

    RankSorter() {
    }

    protected void assignIncomingSortValues() {
        this.rankSize = this.rank.total;
        this.prevRankSize = this.g.ranks.getRank((int)(this.currentRow - 1)).total;
        if (this.currentRow < this.g.ranks.size() - 1) {
            this.nextRankSize = this.g.ranks.getRank((int)(this.currentRow + 1)).total;
        }
        int n = 0;
        while (n < this.rank.count()) {
            this.node = this.rank.getNode(n);
            this.sortValueIncoming(this.g, this.currentRow, this.progress);
            ++n;
        }
    }

    protected void assignOutgoingSortValues() {
        this.rankSize = this.rank.total;
        this.prevRankSize = this.g.ranks.getRank((int)(this.currentRow + 1)).total;
        if (this.currentRow > 1) {
            this.nextRankSize = this.g.ranks.getRank((int)(this.currentRow - 1)).total;
        }
        int n = 0;
        while (n < this.rank.count()) {
            this.node = this.rank.getNode(n);
            this.sortValueOutgoing(this.currentRow, this.progress);
            ++n;
        }
    }

    double evaluateNodeIncoming() {
        boolean change = false;
        EdgeList incoming = this.node.incoming;
        do {
            change = false;
            int i = 0;
            while (i < incoming.size() - 1) {
                if (incoming.getSourceIndex(i) > incoming.getSourceIndex(i + 1)) {
                    Edge e = incoming.getEdge(i);
                    incoming.set(i, incoming.get(i + 1));
                    incoming.set(i + 1, e);
                    change = true;
                }
                ++i;
            }
        } while (change);
        int n = incoming.size();
        if (n == 0) {
            return (double)this.node.index * this.prevRankSize / this.rankSize;
        }
        if (n % 2 == 1) {
            return incoming.getSourceIndex(n / 2);
        }
        int l = incoming.getSourceIndex(n / 2 - 1);
        int r = incoming.getSourceIndex(n / 2);
        if (this.progress >= 0.8) {
            int dr;
            int dl = l - incoming.getSourceIndex(0);
            if (dl < (dr = incoming.getSourceIndex(n - 1) - r)) {
                return l;
            }
            if (dl > dr) {
                return r;
            }
        }
        if (this.progress > 0.25 && this.progress < 0.75) {
            if (this.flipflop.nextBoolean()) {
                return (double)(l + l + r) / 3.0;
            }
            return (double)(r + r + l) / 3.0;
        }
        return (double)(l + r) / 2.0;
    }

    double evaluateNodeOutgoing() {
        boolean change = false;
        EdgeList outgoing = this.node.outgoing;
        do {
            change = false;
            int i = 0;
            while (i < outgoing.size() - 1) {
                if (outgoing.getTargetIndex(i) > outgoing.getTargetIndex(i + 1)) {
                    Edge e = outgoing.getEdge(i);
                    outgoing.set(i, outgoing.get(i + 1));
                    outgoing.set(i + 1, e);
                    change = true;
                }
                ++i;
            }
        } while (change);
        int n = outgoing.size();
        if (n == 0) {
            return (double)this.node.index * this.prevRankSize / this.rankSize;
        }
        if (n % 2 == 1) {
            return outgoing.getTargetIndex(n / 2);
        }
        int l = outgoing.getTargetIndex(n / 2 - 1);
        int r = outgoing.getTargetIndex(n / 2);
        if (this.progress >= 0.8) {
            int dr;
            int dl = l - outgoing.getTargetIndex(0);
            if (dl < (dr = outgoing.getTargetIndex(n - 1) - r)) {
                return l;
            }
            if (dl > dr) {
                return r;
            }
        }
        if (this.progress > 0.25 && this.progress < 0.75) {
            if (this.flipflop.nextBoolean()) {
                return (double)(l + l + r) / 3.0;
            }
            return (double)(r + r + l) / 3.0;
        }
        return (double)(l + r) / 2.0;
    }

    public void sortRankIncoming(DirectedGraph g, Rank rank, int row, double progress) {
        this.currentRow = row;
        this.rank = rank;
        this.progress = progress;
        this.assignIncomingSortValues();
        rank.sort();
        this.postSort();
    }

    public void init(DirectedGraph g) {
        this.g = g;
    }

    protected void postSort() {
        this.rank.assignIndices();
    }

    public void sortRankOutgoing(DirectedGraph g, Rank rank, int row, double progress) {
        this.currentRow = row;
        this.rank = rank;
        this.progress = progress;
        this.assignOutgoingSortValues();
        rank.sort();
        this.postSort();
    }

    void sortValueIncoming(DirectedGraph g, int row, double progress) {
        double value;
        this.node.sortValue = this.evaluateNodeIncoming();
        if (progress == 0.0 && !(this.node instanceof VirtualNode)) {
            this.node.sortValue = -1.0;
        }
        if ((value = this.evaluateNodeOutgoing()) < 0.0) {
            value = (double)this.node.index * this.nextRankSize / this.rankSize;
        }
        this.node.sortValue += value * progress;
    }

    void sortValueOutgoing(int row, double progress) {
        double value;
        this.node.sortValue = this.evaluateNodeOutgoing();
        if (progress == 0.0 && !(this.node instanceof VirtualNode)) {
            this.node.sortValue = -1.0;
        }
        if ((value = this.evaluateNodeIncoming()) < 0.0) {
            value = (double)this.node.index * this.nextRankSize / this.rankSize;
        }
        this.node.sortValue += value * progress;
    }
}

