/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class ContentType
implements IContentType {
    static final byte INVALID = 2;
    static final byte UNKNOWN = 3;
    static final byte VALID = 1;
    private String baseTypeId;
    private IConfigurationElement configurationElement;
    private String defaultCharset;
    private boolean hasDescriberClass;
    private boolean failedDescriberCreation;
    private String[] fileExtensions;
    private String[] fileNames;
    private ContentTypeManager manager;
    private String mimeType;
    private String name;
    private String namespace;
    private String simpleId;
    private byte validation;

    public ContentType(ContentTypeManager manager) {
        this.manager = manager;
    }

    public ContentType(ContentTypeManager manager, IConfigurationElement configurationElement) {
        this.manager = manager;
        this.configurationElement = configurationElement;
    }

    public IContentType getBaseType() {
        if (this.baseTypeId == null) {
            return null;
        }
        return this.manager.getContentType(this.baseTypeId);
    }

    String getBaseTypeId() {
        return this.baseTypeId;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public String getDefaultFileExtension() {
        return null;
    }

    public IContentDescriber getDescriber() {
        ContentType baseType;
        if (!this.failedDescriberCreation && this.hasDescriberClass) {
            try {
                return (IContentDescriber)this.configurationElement.createExecutableExtension("describer-class");
            }
            catch (CoreException ce) {
                this.failedDescriberCreation = true;
                String message = Policy.bind("content.invalidContentDescriber", this.getId());
                Status status = new Status(2, "org.eclipse.core.runtime", 0, message, ce);
                InternalPlatform.getDefault().log(status);
            }
        }
        return (baseType = (ContentType)this.getBaseType()) == null ? null : baseType.getDescriber();
    }

    public String[] getFileExtensions() {
        return this.fileExtensions == null ? new String[]{} : this.fileExtensions;
    }

    public String[] getFileNames() {
        return this.fileNames == null ? new String[]{} : this.fileNames;
    }

    public String getId() {
        return String.valueOf(this.namespace) + '.' + this.simpleId;
    }

    public IContentTypeManager getManager() {
        return this.manager;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    byte getValidation() {
        return this.validation;
    }

    public boolean isAssociatedWith(String fileName) {
        if (this.fileNames != null) {
            int i = 0;
            while (i < this.fileNames.length) {
                if (fileName.equalsIgnoreCase(this.fileNames[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (this.fileExtensions != null) {
            String fileExtension = ContentTypeManager.getFileExtension(fileName);
            if (fileExtension == null) {
                return false;
            }
            int i = 0;
            while (i < this.fileNames.length) {
                if (fileExtension.equalsIgnoreCase(this.fileExtensions[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isKindOf(IContentType another) {
        if (this == another) {
            return true;
        }
        IContentType baseType = this.getBaseType();
        return baseType != null && baseType.isKindOf(another);
    }

    boolean isValid() {
        return this.validation == 1;
    }

    void setBaseTypeId(String baseTypeId) {
        if (baseTypeId == null) {
            this.baseTypeId = null;
            return;
        }
        int separatorPosition = baseTypeId.lastIndexOf(46);
        if (separatorPosition == -1) {
            baseTypeId = String.valueOf(this.namespace) + '.' + baseTypeId;
        }
        this.baseTypeId = baseTypeId;
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public void setDescriberClass(boolean hasDescriberClass) {
        this.hasDescriberClass = hasDescriberClass;
    }

    void setFileExtensions(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    void setFileNames(String[] fileNames) {
        this.fileNames = fileNames;
    }

    void setName(String name) {
        this.name = name;
    }

    void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    void setSimpleId(String simpleId) {
        this.simpleId = simpleId;
    }

    void setValidation(byte validation) {
        this.validation = validation;
    }

    public String toString() {
        return this.getId();
    }
}

