/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ColorSchemeService;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PartTabFolder;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.PresentableViewPart;
import org.eclipse.ui.internal.RectangleAnimation;
import org.eclipse.ui.internal.ViewActionBuilder;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.AbstractDragSource;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.presentations.IPresentablePart;

public class ViewPane
extends PartPane
implements IPropertyListener {
    private PresentableViewPart presentableAdapter = new PresentableViewPart(this);
    private CLabel titleLabel;
    private boolean busy = false;
    private boolean fast = false;
    private boolean showFocus = false;
    private boolean locked = true;
    ToolBar isvToolBar;
    private ToolBarManager isvToolBarMgr;
    private MenuManager isvMenuMgr;
    boolean hasFocus;
    private boolean hadViewMenu = false;

    public ViewPane(IViewReference ref, WorkbenchPage page) {
        super(ref, page);
        this.fast = ref.isFastView();
    }

    public void createControl(Composite parent) {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            return;
        }
        super.createControl(parent);
        DragUtil.addDragSource((Control)this.control, new AbstractDragSource(){

            public Object getDraggedItem(Point position) {
                return ViewPane.this;
            }

            public void dragStarted(Object draggedItem) {
                ViewPane.this.getPage().getActivePerspective().setActiveFastView(null, 0);
            }

            public Rectangle getDragRectangle(Object draggedItem) {
                return DragUtil.getDisplayBounds((Control)ViewPane.this.control);
            }
        });
    }

    protected void createChildControl() {
        IWorkbenchPart[] part = new IWorkbenchPart[]{this.partReference.getPart(false)};
        if (part[0] == null) {
            return;
        }
        if (this.control == null || this.control.getContent() != null) {
            return;
        }
        super.createChildControl();
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                ViewActionBuilder builder = new ViewActionBuilder();
                IViewPart part = (IViewPart)ViewPane.this.getViewReference().getPart(true);
                if (part != null) {
                    builder.readActionExtensions(part);
                    ActionDescriptor[] actionDescriptors = builder.getExtendedActions();
                    KeyBindingService keyBindingService = (KeyBindingService)part.getSite().getKeyBindingService();
                    if (actionDescriptors != null) {
                        int i = 0;
                        while (i < actionDescriptors.length) {
                            PluginAction action;
                            ActionDescriptor actionDescriptor = actionDescriptors[i];
                            if (actionDescriptor != null && (action = actionDescriptors[i].getAction()) != null && action.getActionDefinitionId() != null) {
                                keyBindingService.registerAction((IAction)action);
                            }
                            ++i;
                        }
                    }
                }
                ViewPane.this.updateActionBars();
            }

            public void handleException(Throwable e) {
            }
        });
    }

    private void recreateToolbars() {
        this.createToolBars();
        this.updateActionBars();
    }

    protected WorkbenchPart createErrorPart(WorkbenchPart oldPart) {
        class ErrorViewPart
        extends ViewPart {
            private Text text;
            final /* synthetic */ ViewPane this$0;

            ErrorViewPart(ViewPane viewPane) {
                this.this$0 = viewPane;
            }

            public void createPartControl(Composite parent) {
                this.text = new Text(parent, 74);
                this.text.setForeground(JFaceColors.getErrorText((Display)this.text.getDisplay()));
                this.text.setBackground(this.text.getDisplay().getSystemColor(22));
                this.text.setText(WorkbenchMessages.getString("ViewPane.errorMessage"));
            }

            public void setFocus() {
                if (this.text != null) {
                    this.text.setFocus();
                }
            }

            public void setSite(IWorkbenchPartSite site) {
                super.setSite(site);
            }

            public void setTitle(String title) {
                super.setTitle(title);
            }
        }
        ErrorViewPart newPart = new ErrorViewPart(this);
        PartSite site = (PartSite)oldPart.getSite();
        newPart.setSite(site);
        newPart.setTitle(site.getRegisteredName());
        site.setPart(newPart);
        return newPart;
    }

    public boolean isDragAllowed(Point p) {
        return this.isMoveable() && !this.overImage(p.x) && !this.isZoomed();
    }

    private boolean overImage(int x) {
        if (this.titleLabel.getImage() == null) {
            return false;
        }
        return x < this.titleLabel.getImage().getBounds().width;
    }

    protected void createTitleBar() {
        this.updateTitles();
        this.getPartReference().addPropertyListener(this);
        this.createToolBars();
    }

    private void toolBarResized(ToolBar toolBar, int newSize) {
        if (this.isvToolBar != null) {
            Control ctrl = this.getControl();
            boolean visible = ctrl != null && ctrl.isVisible() && this.toolbarIsVisible();
            this.isvToolBar.setVisible(visible);
        }
        this.presentableAdapter.firePropertyChange(147);
    }

    private void createToolBars() {
        ViewForm parentControl = this.control;
        int barStyle = 0x800040;
        this.isvToolBar = new ToolBar(parentControl.getParent(), barStyle);
        if (this.locked) {
            this.isvToolBar.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent event) {
                    if (ViewPane.this.isvToolBar.getItem(new Point(event.x, event.y)) == null) {
                        ViewPane.this.doZoom();
                    }
                }
            });
        }
        IContributionItem[] isvItems = null;
        if (this.isvToolBarMgr != null) {
            isvItems = this.isvToolBarMgr.getItems();
            this.isvToolBarMgr.dispose();
        }
        this.isvToolBarMgr = new PaneToolBarManager(this.isvToolBar);
        if (isvItems != null) {
            int i = 0;
            while (i < isvItems.length) {
                this.isvToolBarMgr.add(isvItems[i]);
                ++i;
            }
        }
        ColorSchemeService.setViewColors((Control)parentControl);
    }

    public void dispose() {
        super.dispose();
        if (this.isvMenuMgr != null) {
            this.isvMenuMgr.dispose();
        }
        if (this.isvToolBarMgr != null) {
            this.isvToolBarMgr.dispose();
        }
    }

    public void doHide() {
        this.getPage().hideView(this.getViewReference());
    }

    public void doMakeFast() {
        FastViewBar fastViewBar = ((WorkbenchWindow)this.getPage().getWorkbenchWindow()).getFastViewBar();
        if (fastViewBar == null) {
            return;
        }
        Control control = this.getControl();
        Shell shell = control.getShell();
        RectangleAnimation animation = new RectangleAnimation((Composite)shell, DragUtil.getDisplayBounds(control), fastViewBar.getLocationOfNextIcon(), 250);
        animation.schedule();
        this.getPage().addFastView(this.getViewReference());
    }

    protected void doDock() {
        this.getPage().removeFastView(this.getViewReference());
    }

    public Control getDragHandle() {
        return this.control;
    }

    public MenuManager getMenuManager() {
        if (this.isvMenuMgr == null) {
            this.isvMenuMgr = new PaneMenuManager();
        }
        return this.isvMenuMgr;
    }

    public Control[] getTabList() {
        Control c = this.getControl();
        if (this.getContainer() instanceof PartTabFolder) {
            PartTabFolder tf = (PartTabFolder)this.getContainer();
            return tf.getTabList(this);
        }
        return new Control[]{c};
    }

    public ToolBarManager getToolBarManager() {
        return this.isvToolBarMgr;
    }

    public IViewReference getViewReference() {
        return (IViewReference)this.getPartReference();
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 1) {
            this.updateTitles();
        }
    }

    public void setFast(boolean b) {
        this.fast = b;
    }

    void shellActivated() {
    }

    void shellDeactivated() {
    }

    void setActive(boolean active) {
        this.hasFocus = active;
        if (this.getContainer() instanceof PartTabFolder) {
            ((PartTabFolder)this.getContainer()).setActive(active);
        }
    }

    public void showFocus(boolean inFocus) {
        this.setActive(inFocus);
    }

    public void showPaneMenu() {
        ILayoutContainer container = this.getContainer();
        if (container instanceof PartTabFolder) {
            PartTabFolder folder = (PartTabFolder)container;
            folder.showSystemMenu();
        }
    }

    private boolean isFastView() {
        return this.page.isFastView(this.getViewReference());
    }

    boolean isCloseable() {
        return !this.page.isFixedView(this.getViewReference());
    }

    boolean isMoveable() {
        return !this.page.isFixedLayout();
    }

    protected PartPane.Sashes findSashes() {
        PartPane.Sashes result = new PartPane.Sashes();
        ILayoutContainer container = this.getContainer();
        if (container == null) {
            return result;
        }
        container.findSashes(this, result);
        return result;
    }

    public boolean hasViewMenu() {
        if (this.isvMenuMgr != null) {
            return !this.isvMenuMgr.isEmpty();
        }
        return false;
    }

    public void showViewMenu() {
        ILayoutContainer container = this.getContainer();
        if (container instanceof PartTabFolder) {
            PartTabFolder folder = (PartTabFolder)container;
            folder.showPaneMenu();
        }
    }

    public void showViewMenu(Point location) {
        if (!this.hasViewMenu()) {
            return;
        }
        if (this.isFastView() && this.page.getActiveFastView() != this.getViewReference()) {
            return;
        }
        Menu aMenu = this.isvMenuMgr.createContextMenu((Control)this.getControl().getParent());
        aMenu.setLocation(location.x, location.y);
        aMenu.setVisible(true);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode());
    }

    public void updateActionBars() {
        if (this.isvMenuMgr != null) {
            this.isvMenuMgr.updateAll(false);
        }
        if (this.isvToolBarMgr != null) {
            this.isvToolBarMgr.update(false);
        }
    }

    public void updateTitles() {
        this.presentableAdapter.firePropertyChange(1);
    }

    void setImage(CTabItem item, Image image) {
        this.titleLabel.setImage(image);
    }

    public void addSizeMenuItem(Menu menu) {
        if (this.isMoveable()) {
            super.addSizeMenuItem(menu);
        }
    }

    protected void doZoom() {
        if (this.isMoveable()) {
            super.doZoom();
        }
    }

    public void setContainer(ILayoutContainer container) {
        ILayoutContainer oldContainer = this.getContainer();
        if (this.hasFocus) {
            if (oldContainer != null && oldContainer instanceof PartTabFolder) {
                ((PartTabFolder)oldContainer).setActive(false);
            }
            if (container != null && container instanceof PartTabFolder) {
                ((PartTabFolder)container).setActive(true);
            }
        }
        super.setContainer(container);
    }

    public IPresentablePart getPresentablePart() {
        return this.presentableAdapter;
    }

    public void reparent(Composite newParent) {
        super.reparent(newParent);
        if (this.isvToolBar != null) {
            this.isvToolBar.setParent(newParent);
        }
    }

    public void moveAbove(Control refControl) {
        super.moveAbove(refControl);
        this.isvToolBar.moveAbove((Control)this.control);
    }

    public void setVisible(boolean makeVisible) {
        super.setVisible(makeVisible);
        if (this.isvToolBar != null) {
            this.isvToolBar.setVisible(makeVisible && this.toolbarIsVisible());
        }
    }

    protected boolean toolbarIsVisible() {
        ToolBarManager toolbarManager = this.getToolBarManager();
        if (toolbarManager == null) {
            return false;
        }
        ToolBar control = toolbarManager.getControl();
        if (control == null || control.isDisposed()) {
            return false;
        }
        return control.getItemCount() > 0;
    }

    public void setBusy(boolean isBusy) {
        if (isBusy != this.busy) {
            this.busy = isBusy;
            this.presentableAdapter.firePropertyChange(146);
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    class PaneToolBarManager
    extends ToolBarManager {
        public PaneToolBarManager(ToolBar paneToolBar) {
            super(paneToolBar);
        }

        protected void relayout(ToolBar toolBar, int oldCount, int newCount) {
            ViewPane.this.toolBarResized(toolBar, newCount);
            toolBar.layout();
        }
    }

    class PaneMenuManager
    extends MenuManager {
        public PaneMenuManager() {
            super("View Local Menu");
        }

        protected void update(boolean force, boolean recursive) {
            boolean hasMenu;
            super.update(force, recursive);
            boolean bl = hasMenu = !this.isEmpty();
            if (hasMenu != ViewPane.this.hadViewMenu) {
                ViewPane.this.hadViewMenu = hasMenu;
                ViewPane.this.presentableAdapter.firePropertyChange(770);
            }
        }
    }
}

