/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.AbstractActionBarConfigurer;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.presentations.WorkbenchPresentationFactory;

public final class WorkbenchWindowConfigurer
implements IWorkbenchWindowConfigurer {
    private WorkbenchWindow window;
    private int shellStyle = 1264;
    private String windowTitle;
    private boolean showFastViewBars = false;
    private boolean showPerspectiveBar = false;
    private boolean showStatusLine = true;
    private boolean showToolBar = true;
    private boolean showMenuBar = true;
    private boolean showTitleBar = true;
    private boolean showProgressIndicator = true;
    private Map extraData = new HashMap(1);
    private ArrayList transferTypes = new ArrayList(3);
    private DropTargetListener dropTargetListener = null;
    private WindowActionBarConfigurer actionBarConfigurer = null;
    private Point initialSize = new Point(800, 600);
    private AbstractPresentationFactory presentationFactory = new WorkbenchPresentationFactory();

    WorkbenchWindowConfigurer(WorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
    }

    void init() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.showMenuBar = store.getBoolean("SHOULD_SHOW_MENU_BAR");
        this.showProgressIndicator = store.getBoolean("SHOULD_SHOW_PROGRESS_INDICATOR");
        this.showFastViewBars = store.getBoolean("SHOULD_SHOW_FAST_VIEW_BARS");
        this.showPerspectiveBar = store.getBoolean("SHOULD_SHOW_PERSPECTIVE_BAR");
        this.showStatusLine = store.getBoolean("SHOULD_SHOW_STATUS_LINE");
        this.showTitleBar = store.getBoolean("SHOULD_SHOW_TITLE_BAR");
        this.showToolBar = store.getBoolean("SHOULD_SHOW_COOL_BAR");
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public IWorkbenchConfigurer getWorkbenchConfigurer() {
        return Workbench.getInstance().getWorkbenchConfigurer();
    }

    String basicGetTitle() {
        return this.windowTitle;
    }

    public String getTitle() {
        Shell shell = this.window.getShell();
        if (shell != null) {
            this.windowTitle = shell.getText();
            return this.windowTitle;
        }
        return this.windowTitle;
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException();
        }
        this.windowTitle = title;
        Shell shell = this.window.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setText(title);
        }
    }

    public boolean getShowTitleBar() {
        return this.showTitleBar;
    }

    public void setShowTitleBar(boolean show) {
        this.showTitleBar = show;
    }

    public boolean getShowMenuBar() {
        return this.showMenuBar;
    }

    public void setShowMenuBar(boolean show) {
        this.showMenuBar = show;
        WorkbenchWindow win = (WorkbenchWindow)this.getWindow();
        Shell shell = win.getShell();
        if (shell != null) {
            boolean showing;
            boolean bl = showing = shell.getMenuBar() != null;
            if (show != showing) {
                if (show) {
                    shell.setMenuBar(win.getMenuBarManager().getMenu());
                } else {
                    shell.setMenuBar(null);
                }
            }
        }
    }

    public boolean getShowCoolBar() {
        return this.showToolBar;
    }

    public void setShowCoolBar(boolean show) {
        this.showToolBar = show;
    }

    public boolean getShowFastViewBars() {
        return this.showFastViewBars;
    }

    public void setShowFastViewBars(boolean show) {
        this.showFastViewBars = show;
    }

    public boolean getShowPerspectiveBar() {
        return this.showPerspectiveBar;
    }

    public void setShowPerspectiveBar(boolean show) {
        this.showPerspectiveBar = show;
    }

    public boolean getShowStatusLine() {
        return this.showStatusLine;
    }

    public void setShowStatusLine(boolean show) {
        this.showStatusLine = show;
    }

    public boolean getShowProgressIndicator() {
        return this.showProgressIndicator;
    }

    public void setShowProgressIndicator(boolean show) {
        this.showProgressIndicator = show;
    }

    public Object getData(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.extraData.get(key);
    }

    public void setData(String key, Object data) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (data != null) {
            this.extraData.put(key, data);
        } else {
            this.extraData.remove(key);
        }
    }

    public void addEditorAreaTransfer(Transfer tranfer) {
        if (tranfer != null && !this.transferTypes.contains(tranfer)) {
            this.transferTypes.add(tranfer);
            Transfer[] transfers = new Transfer[this.transferTypes.size()];
            this.transferTypes.toArray(transfers);
            IWorkbenchPage[] pages = this.window.getPages();
            int i = 0;
            while (i < pages.length) {
                WorkbenchPage page = (WorkbenchPage)pages[i];
                DropTarget dropTarget = ((EditorArea)page.getEditorPresentation().getLayoutPart()).getDropTarget();
                if (dropTarget != null) {
                    dropTarget.setTransfer(transfers);
                }
                ++i;
            }
        }
    }

    public void configureEditorAreaDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener != null) {
            this.dropTargetListener = dropTargetListener;
            IWorkbenchPage[] pages = this.window.getPages();
            int i = 0;
            while (i < pages.length) {
                WorkbenchPage page = (WorkbenchPage)pages[i];
                DropTarget dropTarget = ((EditorArea)page.getEditorPresentation().getLayoutPart()).getDropTarget();
                if (dropTarget != null) {
                    dropTarget.addDropListener(this.dropTargetListener);
                }
                ++i;
            }
        }
    }

    Transfer[] getTransfers() {
        Transfer[] transfers = new Transfer[this.transferTypes.size()];
        this.transferTypes.toArray(transfers);
        return transfers;
    }

    DropTargetListener getDropTargetListener() {
        return this.dropTargetListener;
    }

    public IActionBarConfigurer getActionBarConfigurer() {
        if (this.actionBarConfigurer == null) {
            this.actionBarConfigurer = new WindowActionBarConfigurer();
        }
        return this.actionBarConfigurer;
    }

    boolean containsCoolItem(String id) {
        this.getActionBarConfigurer();
        return this.actionBarConfigurer.containsCoolItem(id);
    }

    public int getShellStyle() {
        return this.shellStyle;
    }

    public void setShellStyle(int shellStyle) {
        this.shellStyle = shellStyle;
    }

    public Point getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(Point size) {
        this.initialSize = size;
    }

    public AbstractPresentationFactory getPresentationFactory() {
        return this.presentationFactory;
    }

    public void setPresentationFactory(AbstractPresentationFactory factory) {
        this.presentationFactory = factory;
    }

    public void createDefaultContents(Shell shell) {
        this.window.createDefaultContents(shell);
    }

    public Menu createMenuBar() {
        return this.window.getMenuManager().createMenuBar(this.window.getShell());
    }

    public Control createCoolBarControl(Composite parent) {
        return this.window.getCoolBarManager().createControl(parent);
    }

    public Control createStatusLineControl(Composite parent) {
        return this.window.getStatusLineManager().createControl(parent);
    }

    public Control createPageComposite(Composite parent) {
        return this.window.createPageComposite(parent);
    }

    class WindowActionBarConfigurer
    extends AbstractActionBarConfigurer {
        WindowActionBarConfigurer() {
        }

        boolean containsCoolItem(String id) {
            ICoolBarManager cbManager = this.getCoolBarManager();
            if (cbManager == null) {
                return false;
            }
            IContributionItem cbItem = cbManager.find(id);
            return cbItem != null;
        }

        public IStatusLineManager getStatusLineManager() {
            return WorkbenchWindowConfigurer.this.window.getStatusLineManager();
        }

        public IMenuManager getMenuManager() {
            return WorkbenchWindowConfigurer.this.window.getMenuManager();
        }

        public ICoolBarManager getCoolBarManager() {
            return WorkbenchWindowConfigurer.this.window.getCoolBarManager();
        }

        public void registerGlobalAction(IAction action) {
            WorkbenchWindowConfigurer.this.window.registerGlobalAction(action);
        }
    }
}

