/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MultiPageSelectionProvider
implements ISelectionProvider {
    private ListenerList listeners = new ListenerList();
    private MultiPageEditorPart multiPageEditor;

    public MultiPageSelectionProvider(MultiPageEditorPart multiPageEditor) {
        Assert.isNotNull((Object)multiPageEditor);
        this.multiPageEditor = multiPageEditor;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }

                public void handleException(Throwable e) {
                    super.handleException(e);
                    MultiPageSelectionProvider.this.removeSelectionChangedListener(l);
                }
            });
            ++i;
        }
    }

    public MultiPageEditorPart getMultiPageEditor() {
        return this.multiPageEditor;
    }

    public ISelection getSelection() {
        ISelectionProvider selectionProvider;
        IEditorPart activeEditor = this.multiPageEditor.getActiveEditor();
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider selectionProvider;
        IEditorPart activeEditor = this.multiPageEditor.getActiveEditor();
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.setSelection(selection);
        }
    }
}

